/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.security.utils;

import com.ohaotian.plugin.security.entity.AuthorityInfo;
import com.ohaotian.plugin.security.entity.UserInfo;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;

public class SecurityHelper {
    private static final SecurityHelper INSTANCE = new SecurityHelper();
    private static final ThreadLocal<UserInfo> CURRENT_USER = new ThreadLocal();

    public static SecurityHelper getInstance() {
        return INSTANCE;
    }

    public static UserInfo getCurrentUser() {
        UserInfo userInfo = CURRENT_USER.get();
        if (userInfo != null) {
            return userInfo;
        }
        Authentication authentication = SecurityHelper.getCurrentAuthentication();
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        if (principal instanceof UserInfo) {
            userInfo = (UserInfo)principal;
            return userInfo;
        }
        return null;
    }

    public static void setThreadUser(UserInfo userInfo) {
        CURRENT_USER.set(userInfo);
    }

    public void removeThreadUser() {
        CURRENT_USER.remove();
    }

    private static Authentication getCurrentAuthentication() {
        SecurityContext context = SecurityContextHolder.getContext();
        return context == null ? null : context.getAuthentication();
    }

    public static boolean hasAuthority(String authority) {
        UserInfo userInfo = SecurityHelper.getCurrentUser();
        if (userInfo == null) {
            throw new SessionAuthenticationException("\u8bf7\u5148\u767b\u5f55");
        }
        boolean authed = false;
        for (AuthorityInfo authorityInfo : userInfo.getPermission()) {
            if (!authority.equals(authorityInfo.getKey())) continue;
            authed = true;
            break;
        }
        return authed;
    }
}

