/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.log;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;

public class Log4jConfigLoader {
    private List<String> logPaths;

    public List<String> getLogPaths() {
        return this.logPaths;
    }

    public void setLogPaths(List<String> logPaths) {
        this.logPaths = logPaths;
    }

    public void init() {
        ArrayList<String> newList = new ArrayList<String>();
        if (System.getProperty("logConfigFile") != null) {
            this.logPaths.add("file:" + System.getProperty("logConfigFile"));
        }
        for (int i = 0; i < this.logPaths.size(); ++i) {
            String addr;
            String location = this.logPaths.get(i);
            if (location.startsWith("profile:")) {
                String userDir = this.getClass().getClassLoader().getResource("").getFile().toString();
                addr = userDir + "../../../../../" + location.substring(8);
                this.dealPath(newList, addr);
                String addr2 = userDir + "../../../" + location.substring(8);
                this.dealPath(newList, addr2);
                continue;
            }
            if (location.startsWith("classpath:")) {
                String classpath = this.getClass().getClassLoader().getResource("").getFile().toString();
                addr = classpath + location.substring(10);
                this.dealPath(newList, addr);
                continue;
            }
            if (location.startsWith("file:")) {
                this.dealPath(newList, location.substring(5));
                continue;
            }
            this.dealPath(newList, location);
        }
        if (newList.size() < 1) {
            System.out.println("\u65e0\u6709\u6548\u65e5\u5fd7\u6587\u4ef6\u8def\u5f84");
            System.exit(1);
        }
        File file = new File((String)newList.get(newList.size() - 1));
        try {
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            context.setConfigLocation(file.toURI());
            System.out.println("\u91cd\u65b0\u521d\u59cb\u5316Log4j2\u7684\u914d\u7f6e\u4e0a\u4e0b\u6587\uff0c\u914d\u7f6e\u6765\u6e90\uff1a" + (String)newList.get(newList.size() - 1));
            context.reconfigure();
        }
        catch (Exception e) {
            System.out.println("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u51fa\u9519:" + e);
            e.printStackTrace();
        }
    }

    private void dealPath(List<String> newList, String location) {
        if (!new File(location).exists()) {
            System.out.println("\u65e0\u6548\u8def\u5f84:" + location);
        } else {
            newList.add(location);
        }
    }
}

