/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.log;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;

public class Log4jConfigLoader {
    private List<String> logPaths;

    public List<String> getLogPaths() {
        return this.logPaths;
    }

    public void setLogPaths(List<String> logPaths) {
        this.logPaths = logPaths;
    }

    public void init() {
        ArrayList<String> newList = new ArrayList<String>();
        if (System.getProperty("logConfigFile") != null) {
            this.logPaths.add("file:" + System.getProperty("logConfigFile"));
        }
        int i = 0;
        while (i < this.logPaths.size()) {
            String addr;
            String location = this.logPaths.get(i);
            if (location.startsWith("profile:")) {
                String userDir = this.getClass().getClassLoader().getResource("").getFile().toString();
                addr = String.valueOf(userDir) + "../../../../../" + location.substring(8);
                this.dealPath(newList, addr);
                String addr2 = String.valueOf(userDir) + "../../../" + location.substring(8);
                this.dealPath(newList, addr2);
            } else if (location.startsWith("classpath:")) {
                String classpath = this.getClass().getClassLoader().getResource("").getFile().toString();
                addr = String.valueOf(classpath) + location.substring(10);
                this.dealPath(newList, addr);
            } else if (location.startsWith("file:")) {
                this.dealPath(newList, location.substring(5));
            } else {
                this.dealPath(newList, location);
            }
            ++i;
        }
        if (newList.size() < 1) {
            System.out.println("no vaild path to load log-config!");
            System.exit(1);
        }
        File file = new File((String)newList.get(newList.size() - 1));
        try {
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            context.setConfigLocation(file.toURI());
            System.out.println("init log config ---\uff1a" + (String)newList.get(newList.size() - 1));
            context.reconfigure();
        }
        catch (Exception e) {
            System.out.println("init log config failed !!:" + e);
            e.printStackTrace();
        }
    }

    private void dealPath(List<String> newList, String location) {
        if (new File(location).exists()) {
            newList.add(location);
        }
    }
}

