package com.ohaotian.base.log;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;


public class Log4jConfigLoader {

    private List<String> logPaths;
    public List<String> getLogPaths() {
        return logPaths;
    }

    public void setLogPaths(List<String> logPaths) {
        this.logPaths = logPaths;
    }

   /* public Log4jConfigLoader(List<String> logPaths) {

    }*/

    public void init() {
        List<String> newList = new ArrayList<String>();
        //添加JVM参数路径
        if (System.getProperty("logConfigFile") != null) {
            // 启动系统参数-DlogConfigFile=D://log4j2.xml
            logPaths.add("file:" + System.getProperty("logConfigFile"));
        }
        //提取效路径
        for (int i = 0; i < logPaths.size(); i++) {
            String location=logPaths.get(i);
            if (location.startsWith("profile:")) {
                //拼装classloader路径，对应各中心配置文件
                // /E:/projectFile/workspace/hk/user/user-center/target/user-center-1.0-SNAPSHOT/WEB-INF/classes/
                String userDir = getClass().getClassLoader().getResource("").getFile().toString();
                String addr = userDir + "../../../../../" + location.substring(8);
                dealPath(newList,addr);
                String addr2 = userDir + "../../../" + location.substring(8);
                dealPath(newList,addr2);
            } else if (location.startsWith("classpath:")) {
                String classpath = getClass().getClassLoader().getResource("").getFile().toString();
                String addr=classpath + location.substring(10);
                dealPath(newList,addr);
            } else if (location.startsWith("file:")) {
                dealPath(newList,location.substring(5));
            } else {
                dealPath(newList,location);
            }
        }

        if (newList.size() < 1) {
            System.out.println("no vaild path to load log-config!");
            System.exit(1);
        }

        File file = new File(newList.get(newList.size()-1));
        try {
            LoggerContext context =(LoggerContext) LogManager.getContext(false);
            context.setConfigLocation(file.toURI());
            System.out.println("init log config ---："+newList.get(newList.size()-1));
            //重新初始化Log4j2的配置上下文
            context.reconfigure();
        } catch (Exception e) {
            System.out.println("init log config failed !!:" + e);
            e.printStackTrace();
        }
    }

    private void dealPath(List<String> newList,String location){
        if (!new File(location).exists()) {
           // System.out.println("delete path:" + location);
        } else {
            newList.add(location);
        }
    }

}