/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.mq;

import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.ohaotian.base.cache.CacheService;
import com.ohaotian.base.mq.MqProduceService;
import com.ohaotian.base.mq.MqProduceSingleBO;
import com.ohaotian.base.mq.NativeOnsProductor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MqProducerPool
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(MqProducerPool.class);
    private Properties propertyConfigurer;
    private Map<String, Producer> producers = new HashMap<String, Producer>();
    private boolean nativeOns = false;
    private CacheService cacheService;
    private Map<String, Properties> producerProperties = new HashMap<String, Properties>();
    public static final Map<String, String> producerIds = new HashMap<String, String>();
    ApplicationContext applicationContext;

    public void setPropertyConfigurer(Properties propertyConfigurer) {
        this.propertyConfigurer = propertyConfigurer;
    }

    public Properties getPropertyConfigurer() {
        return this.propertyConfigurer;
    }

    public boolean isNativeOns() {
        return this.nativeOns;
    }

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void init() {
        String accessKey = this.propertyConfigurer.getProperty("ons.AccessKey");
        String secretKey = this.propertyConfigurer.getProperty("ons.SecretKey");
        String namesrvAddr = this.propertyConfigurer.getProperty("mq.NAMESRV_ADDR");
        String oNSAddr = this.propertyConfigurer.getProperty("mq.ONSAddr");
        this.nativeOns = Boolean.parseBoolean(this.propertyConfigurer.getProperty("ons.native", "false"));
        Map mqMap = this.applicationContext.getBeansOfType(MqProduceService.class);
        HashMap<String, MqProduceSingleBO> proMap = new HashMap<String, MqProduceSingleBO>();
        for (String key : mqMap.keySet()) {
            MqProduceService mqc = (MqProduceService)mqMap.get(key);
            List<MqProduceSingleBO> msList = mqc.producer();
            if (msList == null) continue;
            for (MqProduceSingleBO ms : msList) {
                proMap.put(ms.getTopic(), ms);
            }
        }
        for (String key : proMap.keySet()) {
            MqProduceSingleBO mbo = (MqProduceSingleBO)proMap.get(key);
            String topic = this.propertyConfigurer.getProperty(mbo.getTopic());
            if (StringUtils.isNotBlank((CharSequence)topic)) {
                topic = topic.trim();
            } else {
                log.error("topic\u548cpid\u7684\u5c5e\u6027\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u53c2\u7167\u5176\u4ed6\u6d88\u606f\u914d\u7f6e\uff01");
            }
            NativeOnsProductor producer = null;
            String pid = this.propertyConfigurer.getProperty(mbo.getPid());
            if (StringUtils.isNotBlank((CharSequence)pid)) {
                pid = pid.trim();
            } else {
                log.error("topic\u548cpid\u7684\u5c5e\u6027\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u53c2\u7167\u5176\u4ed6\u6d88\u606f\u914d\u7f6e\uff01");
            }
            if (this.nativeOns) {
                producer = new NativeOnsProductor(this.cacheService);
                producer.start();
            } else {
                Properties properties = new Properties();
                properties.put("ProducerId", pid);
                if (StringUtils.isNotBlank((CharSequence)accessKey)) {
                    properties.put("AccessKey", accessKey);
                }
                if (StringUtils.isNotBlank((CharSequence)secretKey)) {
                    properties.put("SecretKey", secretKey);
                }
                if (StringUtils.isNotBlank((CharSequence)namesrvAddr)) {
                    properties.put("NAMESRV_ADDR", namesrvAddr);
                }
                if (StringUtils.isNotBlank((CharSequence)oNSAddr)) {
                    properties.put("ONSAddr", oNSAddr);
                }
                producer = ONSFactory.createProducer((Properties)properties);
                producer.start();
                this.producerProperties.put(topic, properties);
            }
            producerIds.put(topic, pid);
            this.producers.put(topic, producer);
        }
    }

    public Producer getProducer(String topic) {
        Producer tp = this.producers.get(topic);
        return tp;
    }

    public synchronized Producer getSynProducer(String topic) {
        Producer tp = this.producers.get(topic);
        if (tp == null) {
            Properties properties = this.producerProperties.get(topic);
            tp = ONSFactory.createProducer((Properties)properties);
            tp.start();
            this.producers.put(topic, tp);
        }
        return tp;
    }
}

