/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.mq;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendCallback;
import com.aliyun.openservices.ons.api.SendResult;
import com.ohaotian.base.cache.CacheService;
import com.ohaotian.base.mq.BO.MessageInfoBO;
import com.ohaotian.base.mq.MqConstants;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeOnsProductor
implements Producer {
    private static final Logger log = LoggerFactory.getLogger(NativeOnsProductor.class);
    private CacheService cacheService;
    private boolean isStarted;

    public NativeOnsProductor(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public boolean isClosed() {
        return !this.isStarted();
    }

    public void start() {
        this.isStarted = true;
    }

    public void shutdown() {
        this.isStarted = false;
    }

    public SendResult send(Message message) {
        SendResult sendResult = new SendResult();
        String msgid = "NAV-" + System.nanoTime();
        sendResult.setMessageId(msgid);
        MessageInfoBO msgbo = new MessageInfoBO();
        msgbo.setBody(message.getBody());
        msgbo.setMsgId(msgid);
        msgbo.setTag(message.getTag());
        msgbo.setTopic(message.getTopic());
        msgbo.setMsgKey(message.getKey());
        msgbo.setSendStatus(MqConstants.PRODUCT_SEND_STATUS_SUCCESS);
        msgbo.setSendTime(new Date());
        this.cacheService.put("LOCALMQ_" + msgid, (Object)msgbo);
        log.debug("LOCALMQ_" + msgid, (Object)msgbo);
        return sendResult;
    }

    public void sendOneway(Message message) {
        throw new UnsupportedOperationException("NativeOnsProductor not support sendOneway");
    }

    public void sendAsync(Message message, SendCallback sendCallback) {
    }
}

