/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.mq;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionChecker;
import com.aliyun.openservices.ons.api.transaction.TransactionStatus;
import com.ohaotian.base.cache.CacheService;
import com.ohaotian.base.mq.MqConstants;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionCheckListenerImpl
implements LocalTransactionChecker {
    private static final Logger log = LoggerFactory.getLogger(TransactionCheckListenerImpl.class);
    private static final boolean isDebugEnable = log.isDebugEnabled();
    private CacheService cacheService;

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public TransactionStatus check(Message msg) {
        String msgId = msg.getMsgID();
        String key = msg.getKey();
        String topic = msg.getTopic();
        String tag = msg.getTag();
        Object body = null;
        Integer status = (Integer)this.cacheService.get(msgId);
        if (status != null) {
            if (MqConstants.PRODUCT_SEND_STATUS_SUCCESS.equals(status)) {
                if (isDebugEnable) {
                    log.debug("check msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "} key={" + key + "}\u6d88\u606f\u53d1\u9001\u6210\u529f! body={" + body + "}");
                }
                try {
                    this.cacheService.delete(msgId);
                    this.cacheService.delete("C_" + msgId);
                }
                catch (Exception e) {
                    log.error("\u5220\u9664redis\u4e2dkey{" + msgId + "} \u548c key {C_" + msgId + "}\u65f6\u5f02\u5e38", (Throwable)e);
                }
                return TransactionStatus.CommitTransaction;
            }
            if (MqConstants.PRODUCT_SEND_STATUS_FAILURE.equals(status)) {
                if (isDebugEnable) {
                    log.debug("check  msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "} key={" + key + "}\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff01 body={" + body + "}");
                }
                try {
                    this.cacheService.delete(msgId);
                    this.cacheService.delete("C_" + msgId);
                }
                catch (Exception e) {
                    log.error("\u5220\u9664redis\u4e2dkey{" + msgId + "} \u548c key {C_" + msgId + "}\u65f6\u5f02\u5e38", (Throwable)e);
                }
                return TransactionStatus.RollbackTransaction;
            }
            log.error("\u672a\u77e5\u7684\u534a\u4e8b\u52a1\u6d88\u606f\u72b6\u6001{" + status + "}msg{" + msg + "}");
            return TransactionStatus.RollbackTransaction;
        }
        Integer cstatus = (Integer)this.cacheService.get("C_" + msgId);
        if (cstatus != null) {
            Long dateTime = this.cacheService.getExpireTimeByKey("C_" + msgId);
            if (dateTime != null && (dateTime == -1L || dateTime == -2L)) {
                this.cacheService.delete(msgId);
                if (isDebugEnable) {
                    log.debug("check msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "}  key={" + key + "}----\u65f6\u95f4\u8fc7\u957f\uff0c\u5220\u9664\u6d88\u606f\uff01 body={" + body + "}");
                }
                return TransactionStatus.RollbackTransaction;
            }
            if (isDebugEnable) {
                log.debug("check msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "}  key={" + key + "} \u72b6\u6001\u672a\u77e5\uff01 body={" + body + "}");
            }
            return TransactionStatus.Unknow;
        }
        if (isDebugEnable) {
            log.debug("check msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "}  key={" + key + "} \u7b2c\u4e00\u6b21check\u4e0d\u5230\uff0c\u6dfb\u52a0\u4e00\u6761\u6d88\u606f body={" + body + "}");
        }
        this.cacheService.put("C_" + msgId, (Object)MqConstants.PRODUCT_SEND_STATUS_TIMETOOLONG, 7200);
        return TransactionStatus.Unknow;
    }

    public static void main(String[] args) {
        long start = new Date().getTime();
        System.out.println(start);
        try {
            Thread.sleep(5001L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        long end = new Date().getTime();
        System.out.println(end - start > 5L);
    }
}

