/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.mq.produce;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.transaction.LocalTransactionExecuter;
import com.aliyun.openservices.ons.api.transaction.TransactionProducer;
import com.aliyun.openservices.ons.api.transaction.TransactionStatus;
import com.ohaotian.base.cache.CacheService;
import com.ohaotian.base.mq.MqMessageListener;
import com.ohaotian.base.mq.MqTranProducerPool;
import com.ohaotian.base.mq.bo.MqConstants;
import com.ohaotian.base.mq.exception.ResourceException;
import com.ohaotian.base.mq.util.ClassUtils;
import com.ohaotian.base.mq.util.LogUtils;
import com.ohaotian.base.mq.util.ReflectionUtils;
import com.ohaotian.base.util.SerializeUtils;
import com.taobao.eagleeye.EagleEye;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqTransactionProducer {
    private static final Logger log = LoggerFactory.getLogger(MqTransactionProducer.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private static Map<Object, LocalTransactionExecuter> execters = new HashMap<Object, LocalTransactionExecuter>();
    private static Map<String, Method> localMethods = new HashMap<String, Method>();
    private static MqTranProducerPool mqTranProducerPool;
    private static CacheService cacheService;

    public void setMqTranProducerPool(MqTranProducerPool mqTranProducerPool) {
        MqTransactionProducer.mqTranProducerPool = mqTranProducerPool;
    }

    public void setCacheService(CacheService cacheService) {
        MqTransactionProducer.cacheService = cacheService;
    }

    public static void sendMsg(Object mQLocalExecuterService, String method, Object arg, String topic, String tag, Object body) {
        topic = mqTranProducerPool.getPropertyConfigurer().getProperty(topic);
        Message msg = new Message(topic, tag, SerializeUtils.serialize((Object)body));
        String traceId = MqTransactionProducer.getTraceId();
        if (StringUtils.isBlank((CharSequence)traceId)) {
            traceId = MqMessageListener.traceIds.get();
        }
        msg.putUserProperties("TraceId", traceId);
        LocalTransactionExecuter localTransactionExecuter = MqTransactionProducer.getLocalTranExecuter(mQLocalExecuterService, method, arg);
        TransactionProducer transactionProducer = mqTranProducerPool.getTransactionProducer(topic);
        if (transactionProducer == null) {
            transactionProducer = mqTranProducerPool.getSynTransactionProducer(topic);
        }
        ResourceException.MQ_THREAD_EXCEPTION.set(null);
        String className = null;
        try {
            Object obj = ClassUtils.getTarget(mQLocalExecuterService);
            className = obj.getClass().getName();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u751f\u4ea7\u8005\u771f\u5b9e\u7c7b\u51fa\u9519\uff0c\u8bf7\u68c0\u6d4b\u4ee3\u7801", (Throwable)e);
        }
        try {
            SendResult srt = transactionProducer.send(msg, localTransactionExecuter, arg);
            LogUtils.printMQProducerLog(className, method, msg, body);
            if (!mqTranProducerPool.isNativeOns()) {
                cacheService.put(msg.getMsgID(), (Object)MqConstants.PRODUCT_SEND_STATUS_SUCCESS, 600);
                if (isDebugEnabled) {
                    log.debug("send tran msg msgId={" + msg.getMsgID() + "}  topic=" + topic + " tag=" + tag + "  key={" + msg.getKey() + "}  body={" + body + "}  SendResult={" + srt + "}");
                }
            }
        }
        catch (ResourceException e) {
            if (!mqTranProducerPool.isNativeOns()) {
                cacheService.put(msg.getMsgID(), (Object)MqConstants.PRODUCT_SEND_STATUS_FAILURE, 600);
            }
            ResourceException re = ResourceException.MQ_THREAD_EXCEPTION.get();
            log.error("send tran msg exception msg={" + msg + "}  body={" + body + "} ", (Throwable)re);
            if (re != null) {
                throw re;
            }
            throw e;
        }
        catch (Throwable e) {
            if (!mqTranProducerPool.isNativeOns() && msg.getMsgID() != null) {
                cacheService.put(msg.getMsgID(), (Object)MqConstants.PRODUCT_SEND_STATUS_FAILURE, 600);
            }
            ResourceException re = ResourceException.MQ_THREAD_EXCEPTION.get();
            log.error("send tran msg exception msg={" + msg + "}  body={" + body + "} ", (Throwable)re);
            if (re != null) {
                LogUtils.printMQErrorLog(className, method, msg, body, re);
                throw re;
            }
            LogUtils.printMQErrorLog(className, method, msg, body, e);
            throw e;
        }
    }

    public static void sendMsg(Object mQLocalExecuterService, String method, Object arg, String topic, String tag, String key, Object body) {
        topic = mqTranProducerPool.getPropertyConfigurer().getProperty(topic);
        Message msg = new Message(topic, tag, key, SerializeUtils.serialize((Object)body));
        String traceId = MqTransactionProducer.getTraceId();
        if (StringUtils.isBlank((CharSequence)traceId)) {
            traceId = MqMessageListener.traceIds.get();
        }
        msg.putUserProperties("TraceId", traceId);
        LocalTransactionExecuter localTransactionExecuter = MqTransactionProducer.getLocalTranExecuter(mQLocalExecuterService, method, arg);
        TransactionProducer transactionProducer = mqTranProducerPool.getTransactionProducer(topic);
        if (transactionProducer == null) {
            transactionProducer = mqTranProducerPool.getSynTransactionProducer(topic);
        }
        ResourceException.MQ_THREAD_EXCEPTION.set(null);
        String className = null;
        try {
            Object obj = ClassUtils.getTarget(mQLocalExecuterService);
            className = obj.getClass().getName();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u751f\u4ea7\u8005\u771f\u5b9e\u7c7b\u51fa\u9519\uff0c\u8bf7\u68c0\u6d4b\u4ee3\u7801", (Throwable)e);
        }
        try {
            SendResult srt = transactionProducer.send(msg, localTransactionExecuter, arg);
            LogUtils.printMQProducerLog(className, method, msg, body);
            if (!mqTranProducerPool.isNativeOns()) {
                cacheService.put(msg.getMsgID(), (Object)MqConstants.PRODUCT_SEND_STATUS_SUCCESS, 600);
                if (isDebugEnabled) {
                    log.debug("send tran msg msgId={" + msg.getMsgID() + "}  topic=" + topic + " tag=" + tag + "  key={" + msg.getKey() + "}  body={" + body + "}  SendResult={" + srt + "}");
                }
            }
        }
        catch (ResourceException e) {
            if (!mqTranProducerPool.isNativeOns()) {
                cacheService.put(msg.getMsgID(), (Object)MqConstants.PRODUCT_SEND_STATUS_FAILURE, 600);
            }
            ResourceException re = ResourceException.MQ_THREAD_EXCEPTION.get();
            log.error("send tran msg exception msg={" + msg + "}  body={" + body + "} ", (Throwable)re);
            if (re != null) {
                throw re;
            }
            throw e;
        }
        catch (Throwable e) {
            if (!mqTranProducerPool.isNativeOns() && msg.getMsgID() != null) {
                cacheService.put(msg.getMsgID(), (Object)MqConstants.PRODUCT_SEND_STATUS_FAILURE, 600);
            }
            ResourceException re = ResourceException.MQ_THREAD_EXCEPTION.get();
            log.error("send tran msg exception msg={" + msg + "}  body={" + body + "} ", (Throwable)re);
            if (re != null) {
                LogUtils.printMQErrorLog(className, method, msg, body, re);
                throw re;
            }
            LogUtils.printMQErrorLog(className, method, msg, body, e);
            throw e;
        }
    }

    private static LocalTransactionExecuter getLocalTranExecuter(Object mQLocalExecuterService, String methodName, Object args) {
        AbstractLocalTransactionExecuter localTransactionExecuter = (AbstractLocalTransactionExecuter)execters.get(mQLocalExecuterService + methodName);
        if (localTransactionExecuter == null) {
            localTransactionExecuter = new AbstractLocalTransactionExecuter(mQLocalExecuterService, methodName);
            execters.put(mQLocalExecuterService + methodName, localTransactionExecuter);
        }
        localTransactionExecuter.setArgs(args);
        return localTransactionExecuter;
    }

    private static void invokeMethod(Object mQLocalExecuterService, String methodName, Object args) throws Exception {
        Method method = localMethods.get(mQLocalExecuterService + methodName);
        if (method == null && (method = ReflectionUtils.getDeclaredMethod(mQLocalExecuterService, methodName)) != null) {
            localMethods.put(mQLocalExecuterService + methodName, method);
        }
        log.debug("method=" + method);
        method.invoke(mQLocalExecuterService, args);
    }

    private static final String getTraceId() {
        String traceId = EagleEye.getTraceId();
        if (StringUtils.isBlank((CharSequence)traceId)) {
            traceId = "";
        }
        return traceId;
    }

    private static class AbstractLocalTransactionExecuter
    implements LocalTransactionExecuter {
        private ThreadLocal<Object> args = new ThreadLocal();
        private final Object mQLocalExecuterService;
        private final String methodName;

        public AbstractLocalTransactionExecuter(Object mQLocalExecuterService, String methodName) {
            this.mQLocalExecuterService = mQLocalExecuterService;
            this.methodName = methodName;
        }

        public void setArgs(Object args) {
            this.args.set(args);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TransactionStatus execute(Message msg, Object arg) {
            try {
                MqTransactionProducer.invokeMethod(this.mQLocalExecuterService, this.methodName, this.args.get());
            }
            catch (Exception e) {
                log.error("msgid:[" + msg.getMsgID() + "]\u672c\u5730\u4e8b\u52a1\u5f02\u5e38\uff0c\u9ed8\u8ba4\u56de\u6eda\u5e76\u56de\u6eda\u6d88\u606f", (Throwable)e);
                TransactionStatus transactionStatus = TransactionStatus.RollbackTransaction;
                return transactionStatus;
            }
            finally {
                this.args.set(null);
            }
            return TransactionStatus.CommitTransaction;
        }
    }
}

