/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.base.mq;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.ohaotian.base.cache.CacheService;
import com.ohaotian.base.mq.MqMessageListener;
import com.ohaotian.base.mq.NativeMqListener;
import com.ohaotian.base.mq.ProjectNameUtils;
import com.ohaotian.base.mq.bo.MqSubScribeSingleBO;
import com.ohaotian.base.mq.interfce.MqCunsumer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MqCunsumerSubscribe
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(MqCunsumerSubscribe.class);
    private final boolean isDebugEnabled = log.isDebugEnabled();
    private static Map<String, Method> localMethods = new HashMap<String, Method>();
    private CacheService cacheService;
    private Properties props;
    private boolean nativeOns = false;
    private static Set<String> excludeConsumerSet = null;
    private static Set<String> excludeReconsumeTimesTopicSet = null;
    public static Map<String, List<MqCunsumer>> nativeTopics = new HashMap<String, List<MqCunsumer>>();

    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ProjectNameUtils pro;
        this.cacheService = (CacheService)applicationContext.getBean("cacheService", CacheService.class);
        this.props = (Properties)applicationContext.getBean("propertyConfigurer", Properties.class);
        if (applicationContext.containsBean("isIntfaceProject") && (pro = (ProjectNameUtils)applicationContext.getBean("isIntfaceProject", ProjectNameUtils.class)).isNeedExcludeMqConsumer()) {
            String[] excludeConsumers = this.props.getProperty("INTERFACE_MQ_CONSUMER", "").split(",");
            excludeConsumerSet = new HashSet<String>(excludeConsumers.length);
            String[] stringArray = excludeConsumers;
            int n = excludeConsumers.length;
            int n2 = 0;
            while (n2 < n) {
                String excludeConsumer = stringArray[n2];
                excludeConsumerSet.add(excludeConsumer.trim());
                ++n2;
            }
        }
        String accessKey = this.props.getProperty("ons.AccessKey");
        String secretKey = this.props.getProperty("ons.SecretKey");
        String namesrvAddr = this.props.getProperty("mq.NAMESRV_ADDR");
        String oNSAddr = this.props.getProperty("mq.ONSAddr");
        String maxReconsumeTimes = this.props.getProperty("mq.MAX_RECONSUME_TIMES");
        String excludeReconsumeTimesTopic = this.props.getProperty("mq.EXCLUDE_RECONSUME_TIMES_TOPIC", "");
        if (this.isDebugEnabled) {
            log.debug("excludeReconsumeTimesTopic=[" + excludeReconsumeTimesTopic + "]");
        }
        if (StringUtils.isNotEmpty((CharSequence)excludeReconsumeTimesTopic)) {
            String[] excludeReconsumeTimesTopicArry = excludeReconsumeTimesTopic.split(",");
            excludeReconsumeTimesTopicSet = new HashSet<String>(excludeReconsumeTimesTopicArry.length);
            String[] stringArray = excludeReconsumeTimesTopicArry;
            int n = excludeReconsumeTimesTopicArry.length;
            int n3 = 0;
            while (n3 < n) {
                String excludeTopic = stringArray[n3];
                excludeReconsumeTimesTopicSet.add(excludeTopic.trim());
                ++n3;
            }
        }
        if (this.isDebugEnabled) {
            log.debug("namesrvAddr=" + namesrvAddr);
            log.debug("oNSAddr=" + oNSAddr);
            log.debug("maxReconsumeTimes=" + maxReconsumeTimes);
        }
        this.nativeOns = Boolean.parseBoolean(this.props.getProperty("ons.native"));
        Map mqMap = applicationContext.getBeansOfType(MqCunsumer.class);
        HashMap mqMapList = new HashMap();
        for (String key : mqMap.keySet()) {
            MqCunsumer mqc = (MqCunsumer)mqMap.get(key);
            MqSubScribeSingleBO mqBO = mqc.subscribe();
            if (mqMapList.get(mqBO.getTopic()) == null) {
                ArrayList<MqCunsumer> mqList = new ArrayList<MqCunsumer>();
                mqList.add(mqc);
                mqMapList.put(mqBO.getTopic(), mqList);
                continue;
            }
            ((List)mqMapList.get(mqBO.getTopic())).add(mqc);
        }
        for (String key : mqMapList.keySet()) {
            List mqcList = (List)mqMapList.get(key);
            try {
                this.startConsumer(accessKey, secretKey, namesrvAddr, oNSAddr, maxReconsumeTimes, mqcList);
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        }
        if (this.nativeOns) {
            NativeMqListener mql = new NativeMqListener(this.cacheService);
            mql.start();
        }
    }

    private void startConsumer(String accessKey, String secretKey, String namesrvAddr, String oNSAddr, String maxReconsumeTimes, List<MqCunsumer> mqcList) {
        MqSubScribeSingleBO mqBO;
        if (mqcList != null && mqcList.size() > 0 && (mqBO = mqcList.get(0).subscribe()) != null && StringUtils.isNotBlank((CharSequence)mqBO.getConsumerId()) && StringUtils.isNotBlank((CharSequence)mqBO.getTopic()) && StringUtils.isNotBlank((CharSequence)mqBO.getTag())) {
            if (excludeConsumerSet != null && excludeConsumerSet.contains(mqBO.getConsumerId().trim())) {
                if (this.isDebugEnabled) {
                    log.debug("\u6392\u9664\u7684ConsumerId=" + mqBO.getConsumerId());
                }
                return;
            }
            Properties properties = new Properties();
            String topic = this.props.getProperty(mqBO.getTopic());
            if (StringUtils.isNotBlank((CharSequence)topic)) {
                topic = topic.trim();
            } else {
                log.error("topic\u4e3a" + mqBO.getTopic() + "\u7684\u6d88\u606f\u4e3b\u9898\u914d\u7f6e\u4e0d\u6b63\u786e\uff01\u8bf7\u914d\u7f6e\uff01");
            }
            if (!(CollectionUtils.isNotEmpty(excludeReconsumeTimesTopicSet) && excludeReconsumeTimesTopicSet.contains(mqBO.getTopic().trim()) || !StringUtils.isNotBlank((CharSequence)maxReconsumeTimes))) {
                properties.put("maxReconsumeTimes", maxReconsumeTimes);
            }
            if (this.nativeOns) {
                nativeTopics.put(topic, mqcList);
            } else {
                String consumeThreadNumsStr;
                String consumerId = this.props.getProperty(mqBO.getConsumerId());
                if (StringUtils.isNotBlank((CharSequence)consumerId)) {
                    consumerId = consumerId.trim();
                } else {
                    log.error("\u6d88\u8d39\u8005id\u4e3a" + mqBO.getConsumerId() + "\u7684\u6d88\u8d39\u8005\u914d\u7f6e\u4e0d\u6b63\u786e\uff01\u8bf7\u914d\u7f6e\uff01");
                }
                properties.put("ConsumerId", consumerId);
                if (StringUtils.isNotBlank((CharSequence)accessKey)) {
                    properties.put("AccessKey", accessKey);
                }
                if (StringUtils.isNotBlank((CharSequence)secretKey)) {
                    properties.put("SecretKey", secretKey);
                }
                if (StringUtils.isNotBlank((CharSequence)namesrvAddr)) {
                    properties.put("NAMESRV_ADDR", namesrvAddr);
                }
                if (StringUtils.isNotBlank((CharSequence)oNSAddr)) {
                    properties.put("ONSAddr", oNSAddr);
                }
                if (StringUtils.isNotBlank((CharSequence)(consumeThreadNumsStr = this.props.getProperty(String.valueOf(mqBO.getConsumerId()) + "_THREAD_NUMS")))) {
                    int consumeThreadNums = Integer.parseInt(consumeThreadNumsStr.trim());
                    properties.put("ConsumeThreadNums", (Object)consumeThreadNums);
                } else {
                    properties.put("ConsumeThreadNums", (Object)5);
                }
                Consumer consumer = ONSFactory.createConsumer((Properties)properties);
                String tag = "";
                for (MqCunsumer mqcu : mqcList) {
                    MqSubScribeSingleBO mgbo = mqcu.subscribe();
                    tag = String.valueOf(tag) + mgbo.getTag() + "||";
                }
                tag = tag.substring(0, tag.length() - 2);
                consumer.subscribe(topic, tag, (MessageListener)new MqMessageListener(this.cacheService, mqcList, mqBO.getTag()));
                log.info("consumerInfo=" + properties.toString(), (Object)("topic=" + topic), (Object)("tag=" + tag));
                System.out.println("consumerInfo=" + properties.toString() + ", topic=" + topic + ", tag=" + tag);
                consumer.start();
            }
        }
    }

    private void invokeMethod(Object service, String methodName, Object args) throws Exception {
        Method method = localMethods.get(service + methodName);
        if (method == null) {
            Class<?> c = service.getClass();
            Method[] methodArray = c.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (methodName.equals(m.getName())) {
                    localMethods.put(service + methodName, m);
                    method = m;
                    break;
                }
                ++n2;
            }
        }
        method.invoke(service, args);
    }
}

