/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.console.controller.function;

import com.ohaotian.filedownload.console.service.function.FunctionDefineService;
import com.ohaotian.filedownload.core.common.BaseResponse;
import com.ohaotian.filedownload.core.common.PageQueryResponse;
import com.ohaotian.filedownload.core.model.function.request.FunctionDefinitionReqVO;
import com.ohaotian.filedownload.core.model.function.request.FunctionQueryVO;
import com.ohaotian.filedownload.core.model.function.response.FunctionDefineRspVO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fileDownloadPlatform/functionDefine"})
public class FunctionDefineController {
    private static final Logger log = LogManager.getLogger(FunctionDefineController.class);
    @Autowired
    private FunctionDefineService functionDefineService;

    @RequestMapping(value={"/detail"})
    BaseResponse<FunctionDefineRspVO> detail(@RequestBody @Validated(value={FunctionDefinitionReqVO.FunctionId.class}) FunctionDefinitionReqVO functionDefinitionReqVO) {
        FunctionDefineRspVO vo = this.functionDefineService.queryFunction(functionDefinitionReqVO.getFunctionId());
        return BaseResponse.success((Object)vo);
    }

    @RequestMapping(value={"/list"})
    BaseResponse<PageQueryResponse> list(@RequestBody FunctionQueryVO functionQueryVO) {
        return this.functionDefineService.queryPageableFunctionList(functionQueryVO);
    }

    @RequestMapping(value={"/add"})
    BaseResponse add(@RequestBody @Validated(value={FunctionDefinitionReqVO.Add.class}) FunctionDefinitionReqVO functionDefinitionReqVO) {
        functionDefinitionReqVO.checkCronExpression();
        this.functionDefineService.saveFunction(functionDefinitionReqVO);
        return BaseResponse.success();
    }

    @RequestMapping(value={"/update"})
    BaseResponse update(@RequestBody @Validated(value={FunctionDefinitionReqVO.Add.class, FunctionDefinitionReqVO.FunctionId.class}) FunctionDefinitionReqVO functionDefinitionReqVO) {
        functionDefinitionReqVO.checkCronExpression();
        this.functionDefineService.updateFunction(functionDefinitionReqVO);
        return BaseResponse.success();
    }

    @RequestMapping(value={"/delete"})
    BaseResponse delete(@RequestBody @Validated(value={FunctionDefinitionReqVO.FunctionId.class}) FunctionDefinitionReqVO functionDefinitionReqVO) {
        this.functionDefineService.delFunction(functionDefinitionReqVO);
        return BaseResponse.success();
    }
}

