/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.console.controller.service;

import com.ohaotian.filedownload.console.service.service.ServiceDefineService;
import com.ohaotian.filedownload.core.aspect.WebLog;
import com.ohaotian.filedownload.core.common.BaseResponse;
import com.ohaotian.filedownload.core.common.PageQueryResponse;
import com.ohaotian.filedownload.core.model.service.request.ServiceDefineQueryReqVO;
import com.ohaotian.filedownload.core.model.service.request.ServiceDefineReqVO;
import com.ohaotian.filedownload.core.model.service.response.ServiceDefineRspVO;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fileDownloadPlatform/serviceDefine"})
public class ServiceDefineController {
    private static final Logger log = LogManager.getLogger(ServiceDefineController.class);
    @Autowired
    private ServiceDefineService serviceDefineService;

    @RequestMapping(value={"/detail"})
    @WebLog(description="\u670d\u52a1\u8be6\u60c5\u9875")
    BaseResponse<ServiceDefineRspVO> detail(@RequestBody ServiceDefineQueryReqVO serviceQuery) {
        Objects.requireNonNull(serviceQuery.getServiceId(), "\u670d\u52a1id[serviceId]\u4e0d\u80fd\u4e3a\u7a7a");
        return BaseResponse.success((Object)this.serviceDefineService.queryServiceDetail(serviceQuery.getServiceId()));
    }

    @RequestMapping(value={"/select/list"})
    BaseResponse selectList(@RequestBody ServiceDefineQueryReqVO serviceQuery) {
        return BaseResponse.success(this.serviceDefineService.queryServiceListByUserId(serviceQuery));
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.POST})
    BaseResponse<PageQueryResponse> pageableList(@RequestBody ServiceDefineQueryReqVO serviceQuery) {
        return this.serviceDefineService.queryServicePageableList(serviceQuery);
    }

    @RequestMapping(value={"/add"})
    @WebLog(description="\u65b0\u589e\u670d\u52a1")
    BaseResponse add(@RequestBody @Validated(value={ServiceDefineReqVO.Add.class}) ServiceDefineReqVO serviceDefine) {
        this.serviceDefineService.addServiceDefine(serviceDefine);
        return BaseResponse.success();
    }

    @RequestMapping(value={"/update"})
    BaseResponse update(@RequestBody @Validated(value={ServiceDefineReqVO.Add.class, ServiceDefineReqVO.ServiceId.class}) ServiceDefineReqVO serviceDefine) {
        this.serviceDefineService.updateServiceDefine(serviceDefine);
        return BaseResponse.success();
    }

    @RequestMapping(value={"/delete"})
    BaseResponse delete(@RequestBody @Validated(value={ServiceDefineReqVO.ServiceId.class}) ServiceDefineReqVO serviceDefine) {
        return this.serviceDefineService.delServiceDefine(serviceDefine.getServiceId());
    }
}

