/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.console.controller.template;

import com.ohaotian.filedownload.console.service.template.TemplateService;
import com.ohaotian.filedownload.core.aspect.WebLog;
import com.ohaotian.filedownload.core.common.BaseResponse;
import com.ohaotian.filedownload.core.model.template.request.TemplateDefinitionReqVO;
import com.ohaotian.filedownload.core.model.template.request.TemplateQueryReqVO;
import com.ohaotian.filedownload.core.model.template.request.UploadTemplateReqVO;
import com.ohaotian.filedownload.core.model.template.response.TemplateRspVO;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fileDownloadPlatform/fileTemplate"})
public class TemplateController {
    private static final Logger log = LoggerFactory.getLogger(TemplateController.class);
    @Autowired
    private TemplateService templateService;

    @PostMapping(value={"/add"})
    @WebLog(description="\u6587\u4ef6\u6a21\u677f\u65b0\u589e")
    public BaseResponse addTemplate(@RequestBody @Validated(value={TemplateDefinitionReqVO.Add.class}) TemplateDefinitionReqVO templateDefinitionReqVO) {
        this.templateService.saveTemplate(templateDefinitionReqVO);
        return BaseResponse.success();
    }

    @PostMapping(value={"/update"})
    @WebLog(description="\u6587\u4ef6\u6a21\u677f\u4fee\u6539")
    public BaseResponse updateTemplate(@RequestBody @Validated(value={TemplateDefinitionReqVO.Add.class, TemplateDefinitionReqVO.TemplateId.class}) TemplateDefinitionReqVO templateDefinitionReqVO) {
        this.templateService.updateTemplate(templateDefinitionReqVO);
        return BaseResponse.success();
    }

    @PostMapping(value={"/upload"})
    @WebLog(description="\u6587\u4ef6\u6a21\u677f\u4e0a\u4f20")
    public BaseResponse uploadTemplate(@Validated UploadTemplateReqVO uploadTemplateReqVO) {
        if (uploadTemplateReqVO.getFile().isEmpty()) {
            BaseResponse.fail((String)"file\u6587\u4ef6\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        return BaseResponse.success(this.templateService.uploadTemplate(uploadTemplateReqVO));
    }

    @PostMapping(value={"/delete"})
    @WebLog(description="\u6587\u4ef6\u6a21\u677f\u5220\u9664")
    public BaseResponse deleteTemplate(@RequestBody @Validated(value={TemplateDefinitionReqVO.TemplateId.class}) TemplateDefinitionReqVO deleteTemplateDetailReqBO) {
        return this.templateService.deleteTemplate(deleteTemplateDetailReqBO);
    }

    @PostMapping(value={"/detail"})
    @WebLog(description="\u6587\u4ef6\u6a21\u677f\u8be6\u60c5")
    public BaseResponse queryTemplateDetail(@RequestBody TemplateQueryReqVO templateQuery) {
        Objects.requireNonNull(templateQuery.getFileTemplateId(), "\u5f53\u524d\u5b57\u6bb5\u4e0d\u53ef\u4e3a\u7a7a");
        return BaseResponse.success((Object)this.templateService.queryTemplate(templateQuery));
    }

    @PostMapping(value={"/list"})
    @WebLog(description="\u5206\u9875\u67e5\u8be2\u6587\u4ef6\u6a21\u677f")
    public BaseResponse queryTemplateList(@RequestBody TemplateQueryReqVO templateQueryReqVO) {
        return this.templateService.queryTemplateList(templateQueryReqVO);
    }

    @PostMapping(value={"/select/list"})
    @WebLog(description="\u6587\u4ef6\u6a21\u677f\u4e0b\u62c9\u5217\u8868list")
    public BaseResponse<List<TemplateRspVO>> queryTemplateListSelected(@RequestBody TemplateQueryReqVO templateQuery) {
        return BaseResponse.success(this.templateService.queryTemplateListSelected(templateQuery));
    }

    @PostMapping(value={"backup"})
    @WebLog(description="\u5907\u4efd\u6a21\u677f\u5185\u5bb9")
    public BaseResponse backup() {
        return BaseResponse.success((Object)this.templateService.backup());
    }
}

