/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.console.schedule;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.filedownload.common.utils.HttpUtil;
import com.ohaotian.filedownload.console.service.task.TaskService;
import com.ohaotian.filedownload.core.dao.entity.TaskPO;
import com.ohaotian.filedownload.core.enums.TaskStatusEnum;
import com.ohaotian.filedownload.core.exception.FDSException;
import com.ohaotian.filedownload.core.exception.FDSResponseInfoEnum;
import com.ohaotian.filedownload.core.model.task.request.TaskDownloadRecordDataBO;
import com.ohaotian.filedownload.core.model.task.request.TaskDownloadRecordListReqBO;
import java.io.File;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UpdateRunningTaskFailTask {
    private static final Logger log = LoggerFactory.getLogger(UpdateRunningTaskFailTask.class);
    @Autowired
    private TaskService taskService;
    @Value(value="${file.tmpDir}")
    private String fileTmpDir;
    private final String IS_CALLBACK_YES = "1";
    @Value(value="${download.task.callback.switch:0}")
    private String isCallback;
    @Value(value="${download.task.callback.address:1}")
    private String callbackUrl;

    @Scheduled(cron="0 0 0/1 * * ? ")
    public void run() {
        log.info("## \u5b9a\u65f6\u5c06\u957f\u65f6\u95f4\u5904\u4e8e\u8fdb\u884c\u4e2d\u7684\u4efb\u52a1\u5f3a\u5236\u7f6e\u4e3a\u5931\u8d25 task start ...");
        LocalDateTime lastTime = LocalDateTime.now().minus(1L, ChronoUnit.HOURS);
        List<TaskPO> taskPoList = this.taskService.queryAlwaysRunningTask(lastTime);
        if (CollectionUtils.isEmpty(taskPoList)) {
            log.info("## \u65e0\u957f\u65f6\u95f4\u5904\u4e8e\u8fdb\u884c\u4e2d\u7684\u4efb\u52a1 ...");
            return;
        }
        List<Long> taskIds = taskPoList.stream().map(TaskPO::getTaskId).collect(Collectors.toList());
        this.taskService.updateTasksFail(taskIds, "\u4efb\u52a1\u957f\u65f6\u95f4\u5904\u4e8e\u8fdb\u884c\u4e2d\uff0c\u7cfb\u7edf\u5f3a\u5236\u7f6e\u4e3a\u5931\u8d25[\u53ef\u80fd\u539f\u56e0: JVM \u5f02\u5e38\u9000\u51fa&\u5b95\u673a\u7b49\u60c5\u51b5]");
        taskPoList.forEach(taskPo -> {
            this.taskStatusCallback(taskPo.getTaskId(), TaskStatusEnum.FAIL.getCode());
            String generalTaskFileDir = String.format("%s/%s/general/%d", this.fileTmpDir, taskPo.getBusinessCenterId(), taskPo.getTaskId());
            File dir = new File(generalTaskFileDir);
            if (dir.exists()) {
                dir.delete();
            }
        });
        log.info("## \u5b9a\u65f6\u5c06\u957f\u65f6\u95f4\u5904\u4e8e\u8fdb\u884c\u4e2d\u7684\u4efb\u52a1\u5f3a\u5236\u7f6e\u4e3a\u5931\u8d25 task end ...");
    }

    private void taskStatusCallback(Long taskId, int callBackStatus) {
        JSONObject paramJson = new JSONObject();
        if ("1".equals(this.isCallback)) {
            ArrayList<TaskDownloadRecordDataBO> taskDownloadRecordDataBOList = new ArrayList<TaskDownloadRecordDataBO>();
            TaskDownloadRecordDataBO taskDownloadRecordDataBO = new TaskDownloadRecordDataBO();
            taskDownloadRecordDataBO.setTaskId(String.valueOf(taskId));
            taskDownloadRecordDataBO.setTaskStatus(String.valueOf(callBackStatus));
            taskDownloadRecordDataBOList.add(taskDownloadRecordDataBO);
            TaskDownloadRecordListReqBO taskDownloadRecordListReqBO = new TaskDownloadRecordListReqBO();
            taskDownloadRecordListReqBO.setUpdateTaskBOS(taskDownloadRecordDataBOList);
            log.info("\u56de\u8c03\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)taskDownloadRecordListReqBO));
            String result = "";
            try {
                result = HttpUtil.doPost((String)this.callbackUrl, (String)JSON.toJSONString((Object)taskDownloadRecordListReqBO));
                log.info("\u56de\u8c03\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
            }
            catch (Exception e) {
                log.info("\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.toString());
                throw new FDSException(FDSResponseInfoEnum.TASK_CALLBACK_FAILED_EXCEPTION);
            }
        }
    }
}

