/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.console.service.dic.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.filedownload.console.service.dic.DictionaryService;
import com.ohaotian.filedownload.core.atom.TranslateRspBo;
import com.ohaotian.filedownload.core.common.BaseResponse;
import com.ohaotian.filedownload.core.dao.entity.DicDictionaryPO;
import com.ohaotian.filedownload.core.dao.mapper.DicDictionaryMapper;
import com.ohaotian.filedownload.core.model.dic.bo.DictionaryDataBo;
import com.ohaotian.filedownload.core.model.dic.bo.DictionaryReqBo;
import com.ohaotian.filedownload.core.model.dic.bo.DictionaryRspBo;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictionaryServiceImpl
implements DictionaryService {
    @Autowired
    private DicDictionaryMapper dicDictionaryMapper;

    @Override
    public BaseResponse<DictionaryRspBo> queryPageDictionaryList(DictionaryReqBo dictionaryReqBo) {
        BaseResponse retBo = new BaseResponse();
        String judge = this.verification(dictionaryReqBo);
        if (judge != null) {
            retBo.setCode("1");
            retBo.setMessage(judge);
            return retBo;
        }
        DicDictionaryPO reqPo = new DicDictionaryPO();
        reqPo.setPCode(dictionaryReqBo.getPCode());
        List dicPos = this.dicDictionaryMapper.getListByCondition(reqPo);
        List codes = JSON.parseArray((String)JSON.toJSONString((Object)dicPos), DictionaryDataBo.class);
        DictionaryRspBo data = new DictionaryRspBo();
        data.setCodes(codes);
        retBo.setCode("0");
        retBo.setMessage("success");
        retBo.setData((Object)data);
        return retBo;
    }

    @Override
    public BaseResponse<TranslateRspBo> queryDictionaryByPCode(DictionaryReqBo dictionaryReqBo) {
        BaseResponse retBo = new BaseResponse();
        TranslateRspBo translateRspBo = new TranslateRspBo();
        HashMap<String, String> maps = new HashMap<String, String>();
        String judge = this.verification(dictionaryReqBo);
        if (judge != null) {
            retBo.setCode("1");
            retBo.setMessage(judge);
            return retBo;
        }
        DicDictionaryPO reqPo = new DicDictionaryPO();
        reqPo.setPCode(dictionaryReqBo.getPCode());
        List dicPos = this.dicDictionaryMapper.getListByCondition(reqPo);
        if (dicPos != null) {
            for (DicDictionaryPO dicPo : dicPos) {
                String mapK = dicPo.getCode();
                String mapV = dicPo.getTitle();
                maps.put(mapK, mapV);
            }
        }
        translateRspBo.setTranslate(maps);
        retBo.setCode("0");
        retBo.setMessage("success");
        retBo.setData((Object)translateRspBo);
        return retBo;
    }

    public String verification(DictionaryReqBo reqBo) {
        if (reqBo == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getPCode() == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u7684pCode\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

