/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.console.service.service.impl;

import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.filedownload.console.service.dic.DictionaryService;
import com.ohaotian.filedownload.console.service.service.ServiceDefineService;
import com.ohaotian.filedownload.core.atom.TranslateRspBo;
import com.ohaotian.filedownload.core.common.BaseResponse;
import com.ohaotian.filedownload.core.common.PageQueryResponse;
import com.ohaotian.filedownload.core.dao.entity.FunctionDefinePO;
import com.ohaotian.filedownload.core.dao.entity.HttpServiceConfigPO;
import com.ohaotian.filedownload.core.dao.entity.ServiceDefinePO;
import com.ohaotian.filedownload.core.dao.mapper.FunctionDefinePOMapper;
import com.ohaotian.filedownload.core.dao.mapper.HttpServiceConfigPOMapper;
import com.ohaotian.filedownload.core.dao.mapper.ServiceDefinePOMapper;
import com.ohaotian.filedownload.core.exception.FDSException;
import com.ohaotian.filedownload.core.exception.FDSResponseInfoEnum;
import com.ohaotian.filedownload.core.model.dic.bo.DictionaryReqBo;
import com.ohaotian.filedownload.core.model.service.request.HttpConfig;
import com.ohaotian.filedownload.core.model.service.request.ServiceDefineQueryReqVO;
import com.ohaotian.filedownload.core.model.service.request.ServiceDefineReqVO;
import com.ohaotian.filedownload.core.model.service.response.ServiceDefineRspVO;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dozer.Mapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceDefineServiceImpl
implements ServiceDefineService {
    @Autowired
    private ServiceDefinePOMapper serviceDefineMapper;
    @Autowired
    private HttpServiceConfigPOMapper httpServiceConfigMapper;
    @Autowired
    private FunctionDefinePOMapper functionDefineMapper;
    @Autowired
    private Mapper mapper;
    @Autowired
    private DictionaryService dictionaryService;

    @Override
    public ServiceDefineRspVO queryServiceDetail(Long serviceId) {
        HttpServiceConfigPO httpServiceConfigPo = this.httpServiceConfigMapper.selectByServiceId(serviceId);
        ServiceDefinePO serviceDefinePo = this.serviceDefineMapper.selectByPrimaryKey(serviceId);
        if (serviceDefinePo == null) {
            throw new FDSException(FDSResponseInfoEnum.NO_AVAILABLE_SERVICE);
        }
        ServiceDefineRspVO serviceDefineRspVO = (ServiceDefineRspVO)this.mapper.map((Object)serviceDefinePo, ServiceDefineRspVO.class);
        if (httpServiceConfigPo == null) {
            return serviceDefineRspVO;
        }
        HttpConfig httpConfig = (HttpConfig)this.mapper.map((Object)httpServiceConfigPo, HttpConfig.class);
        serviceDefineRspVO.setHttpConfig(httpConfig);
        DictionaryReqBo dictionaryReqBo = new DictionaryReqBo();
        dictionaryReqBo.setPCode("SERVICE_TYPE");
        BaseResponse<TranslateRspBo> dicRetBo = this.dictionaryService.queryDictionaryByPCode(dictionaryReqBo);
        if ("0".equals(dicRetBo.getCode())) {
            TranslateRspBo data = (TranslateRspBo)dicRetBo.getData();
            Map translateMap = data.getTranslate();
            serviceDefineRspVO.setServiceTypeStr((String)translateMap.get(Integer.toString(serviceDefineRspVO.getServiceType())));
        }
        return serviceDefineRspVO;
    }

    @Override
    public List<ServiceDefineRspVO> queryServiceListByUserId(ServiceDefineQueryReqVO queryServiceDefineListReqBO) {
        return this.serviceDefineMapper.queryListBy(queryServiceDefineListReqBO.getUserId(), queryServiceDefineListReqBO.confirmAuthority().intValue());
    }

    @Override
    public BaseResponse<PageQueryResponse> queryServicePageableList(ServiceDefineQueryReqVO serviceQuery) {
        serviceQuery.queryLikeByServiceName();
        PageInfo pageInfo = PageMethod.startPage((int)serviceQuery.getPageNo(), (int)serviceQuery.getPageSize()).doSelectPageInfo(() -> this.serviceDefineMapper.queryPageList(serviceQuery, serviceQuery.confirmAuthority().intValue()));
        DictionaryReqBo dictionaryReqBo = new DictionaryReqBo();
        dictionaryReqBo.setPCode("SERVICE_TYPE");
        BaseResponse<TranslateRspBo> dicRetBo = this.dictionaryService.queryDictionaryByPCode(dictionaryReqBo);
        if ("0".equals(dicRetBo.getCode())) {
            TranslateRspBo data = (TranslateRspBo)dicRetBo.getData();
            Map translateMap = data.getTranslate();
            pageInfo.getList().forEach(item -> item.setServiceTypeStr((String)translateMap.get(Integer.toString(item.getServiceType()))));
        }
        return PageQueryResponse.success((PageInfo)pageInfo);
    }

    @Override
    public List<ServiceDefineRspVO> queryServiceListWithHttpConfig(List<Long> serviceIds, String businessCenterId) {
        List httpServiceConfigPoS = this.httpServiceConfigMapper.selectByServiceIds(serviceIds);
        Map<Long, HttpServiceConfigPO> serviceConfigPoMap = httpServiceConfigPoS.stream().collect(Collectors.toMap(HttpServiceConfigPO::getServiceId, p -> p));
        List serviceDefinePoS = this.serviceDefineMapper.selectByServiceIds(serviceIds, businessCenterId);
        List queryServiceDefineRspBoS = serviceDefinePoS.stream().map(service -> ServiceDefineRspVO.builder().businessCenterId(service.getBusinessCenterId()).serviceDesc(service.getServiceDesc()).serviceId(service.getServiceId()).serviceName(service.getServiceName()).serviceType(service.getServiceType()).build()).collect(Collectors.toList());
        return queryServiceDefineRspBoS.stream().peek(service -> {
            HttpServiceConfigPO httpServiceConfigPo = (HttpServiceConfigPO)serviceConfigPoMap.get(service.getServiceId());
            HttpConfig httpConfig = (HttpConfig)this.mapper.map((Object)httpServiceConfigPo, HttpConfig.class);
            service.setHttpConfig(httpConfig);
        }).collect(Collectors.toList());
    }

    @Override
    public boolean addServiceDefine(ServiceDefineReqVO serviceDefineReqVO) {
        serviceDefineReqVO.checkHttpConfigParam();
        LocalDateTime createTime = LocalDateTime.now();
        ServiceDefinePO serviceDefinePo = (ServiceDefinePO)this.mapper.map((Object)serviceDefineReqVO, ServiceDefinePO.class);
        serviceDefinePo.setCreateTime(createTime);
        serviceDefinePo.setCreateUserId(serviceDefineReqVO.getUserId());
        List records = this.serviceDefineMapper.findByPO(serviceDefinePo);
        if (records != null && records.size() > 0) {
            throw new FDSException(FDSResponseInfoEnum.NAME_EXISTS_EXCEPTION);
        }
        this.serviceDefineMapper.insertSelective(serviceDefinePo);
        HttpServiceConfigPO httpServiceConfigPo = (HttpServiceConfigPO)this.mapper.map((Object)serviceDefineReqVO.getHttpConfig(), HttpServiceConfigPO.class);
        httpServiceConfigPo.setServiceId(serviceDefinePo.getServiceId());
        httpServiceConfigPo.setCreateTime(createTime);
        this.httpServiceConfigMapper.insertSelective(httpServiceConfigPo);
        return true;
    }

    @Override
    public boolean updateServiceDefine(ServiceDefineReqVO serviceDefineReqVO) {
        serviceDefineReqVO.checkHttpConfigParam();
        ServiceDefinePO serviceDefinePo = (ServiceDefinePO)this.mapper.map((Object)serviceDefineReqVO, ServiceDefinePO.class);
        serviceDefinePo.setUpdateTime(LocalDateTime.now());
        serviceDefinePo.setUpdateUserId(serviceDefineReqVO.getUserId());
        this.serviceDefineMapper.updateByPrimaryKeySelective(serviceDefinePo);
        HttpServiceConfigPO httpServiceConfigPo = (HttpServiceConfigPO)this.mapper.map((Object)serviceDefineReqVO.getHttpConfig(), HttpServiceConfigPO.class);
        httpServiceConfigPo.setServiceId(serviceDefinePo.getServiceId());
        httpServiceConfigPo.setUpdateTime(LocalDateTime.now());
        this.httpServiceConfigMapper.updateByPrimaryKeySelective(httpServiceConfigPo);
        return true;
    }

    @Override
    public BaseResponse delServiceDefine(Long serviceId) {
        FunctionDefinePO functionDefinePo = new FunctionDefinePO();
        functionDefinePo.setServiceId(serviceId);
        if (!this.functionDefineMapper.findByPO(functionDefinePo).isEmpty() || this.functionDefineMapper.findByPO(functionDefinePo).size() >= 1) {
            BaseResponse baseResponse = new BaseResponse();
            baseResponse.setCode("1");
            baseResponse.setMessage("\u6709\u529f\u80fd\u5728\u4f7f\u7528\u8be5\u670d\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
            return baseResponse;
        }
        this.httpServiceConfigMapper.deleteByServiceId(serviceId);
        this.serviceDefineMapper.deleteByPrimaryKey(serviceId);
        return BaseResponse.success();
    }
}

