/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.console.service.task.impl;

import com.ohaotian.filedownload.console.service.business.TaskMasterService;
import com.ohaotian.filedownload.console.service.task.TaskService;
import com.ohaotian.filedownload.core.dao.entity.TaskPO;
import com.ohaotian.filedownload.core.dao.mapper.TaskPOMapper;
import com.ohaotian.filedownload.core.enums.TaskStatusEnum;
import com.ohaotian.filedownload.core.exception.FDSException;
import com.ohaotian.filedownload.core.exception.FDSResponseInfoEnum;
import com.ohaotian.filedownload.core.model.business.bo.TaskProgress;
import com.ohaotian.filedownload.core.model.task.request.TaskDefinitionReqVO;
import com.ohaotian.filedownload.core.model.task.request.TaskQueryReqVO;
import com.ohaotian.filedownload.core.model.task.response.TaskDetailRspVO;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.dozer.Mapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskServiceImpl
implements TaskService {
    private static final Logger log = LoggerFactory.getLogger(TaskServiceImpl.class);
    @Autowired
    private TaskPOMapper taskMapper;
    @Autowired
    private Mapper mapper;
    @Autowired
    private TaskMasterService taskMasterService;

    @Override
    public int insertNewTask(TaskPO taskPo) {
        taskPo.setTaskStatus(Integer.valueOf(TaskStatusEnum.ING.getCode()));
        int count = this.taskMapper.insert(taskPo);
        if (count <= 0) {
            throw new FDSException(FDSResponseInfoEnum.COMMIT_TASK_FAIL);
        }
        return count;
    }

    @Override
    public int updateTaskProgress(TaskProgress taskProgress) {
        TaskPO taskPo = (TaskPO)this.mapper.map((Object)taskProgress, TaskPO.class);
        return this.taskMapper.updateByPrimaryKeySelective(taskPo);
    }

    @Override
    public TaskDetailRspVO queryTask(TaskDefinitionReqVO taskCommitReqBO, boolean isApiQuery) {
        TaskPO taskPo = isApiQuery ? this.taskMapper.queryTaskDetailBy(taskCommitReqBO.getTaskId(), taskCommitReqBO.getBusinessCenterId(), taskCommitReqBO.getUserId()) : this.taskMapper.selectByPrimaryKeyWithAuth(taskCommitReqBO.getTaskId(), taskCommitReqBO.getAuthority(), taskCommitReqBO.getUserId());
        if (taskPo == null) {
            log.error("\u672a\u77e5\u7684\u4e0b\u8f7d\u4efb\u52a1\u3002taskId:{}", (Object)taskCommitReqBO.getTaskId());
            throw new FDSException(FDSResponseInfoEnum.TASK_UN_EXISTS_EXCEPTION);
        }
        return this.getTaskDetailRspVO(taskPo);
    }

    @Override
    public List<TaskDetailRspVO> queryTaskList(TaskQueryReqVO taskQueryReqVO) {
        List taskPoS = this.taskMapper.findBy(taskQueryReqVO);
        return taskPoS.stream().map(this::getTaskDetailRspVO).collect(Collectors.toList());
    }

    @Override
    public List<TaskPO> queryAlwaysRunningTask(LocalDateTime lastTime) {
        return this.taskMapper.queryAlwaysRunningTask(lastTime);
    }

    @Override
    public int queryRunningTaskCount() {
        return this.taskMapper.queryRunningTaskCount();
    }

    @Override
    public int updateTasksFail(List<Long> taskIds, String failReason) {
        return this.taskMapper.updateTasksFail(taskIds, failReason);
    }

    private TaskDetailRspVO getTaskDetailRspVO(TaskPO taskPo) {
        TaskDetailRspVO taskDetailRspVO = (TaskDetailRspVO)this.mapper.map((Object)taskPo, TaskDetailRspVO.class);
        taskDetailRspVO.mappingField();
        TaskProgress taskProgress = this.taskMasterService.queryProgress(taskDetailRspVO.getTaskId());
        taskDetailRspVO.setTaskProgress(taskProgress);
        return taskDetailRspVO;
    }
}

