/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.console.service.tepmtepmlate.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.filedownload.console.service.tepmtepmlate.TempTemplateService;
import com.ohaotian.filedownload.core.common.BaseResponse;
import com.ohaotian.filedownload.core.dao.entity.FunctionDefinePO;
import com.ohaotian.filedownload.core.dao.entity.TemplatePO;
import com.ohaotian.filedownload.core.dao.mapper.FunctionDefinePOMapper;
import com.ohaotian.filedownload.core.dao.mapper.TemplatePOMapper;
import com.ohaotian.filedownload.core.model.temptemplate.bo.FieldDataBO;
import com.ohaotian.filedownload.core.model.temptemplate.bo.TempTemplateQryFieldReqBO;
import com.ohaotian.filedownload.core.model.temptemplate.bo.TempTemplateQryFieldRspBO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="tempTemplateService")
public class TempTemplateServiceImpl
implements TempTemplateService {
    private static final Logger log = LoggerFactory.getLogger(TempTemplateServiceImpl.class);
    @Autowired
    private FunctionDefinePOMapper functionDefinePOMapper;
    @Autowired
    private TemplatePOMapper templatePOMapper;

    @Override
    public BaseResponse<TempTemplateQryFieldRspBO> getAttrsByFunc(TempTemplateQryFieldReqBO reqBO) {
        log.info("TempTemplateServiceImpl -> getAttrsByFunc(), \u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        TempTemplateQryFieldRspBO rspBO = new TempTemplateQryFieldRspBO();
        String checkResult = this.checkParam(reqBO);
        if (!StringUtils.isEmpty((Object)checkResult)) {
            return BaseResponse.fail((String)checkResult);
        }
        FunctionDefinePO functionDefinePo = this.functionDefinePOMapper.findByIdAndCode(reqBO.getFunctionId(), reqBO.getFunctionCode());
        if (functionDefinePo == null) {
            return BaseResponse.fail((String)"\u672a\u627e\u5230\u5bf9\u5e94\u529f\u80fd\u4fe1\u606f");
        }
        rspBO.setFileName(functionDefinePo.getFunctionName());
        TemplatePO templatePO = this.templatePOMapper.selectByPrimaryKey(functionDefinePo.getTemplateId());
        if (templatePO == null) {
            return BaseResponse.fail((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6a21\u677f\u4fe1\u606f");
        }
        if (templatePO.getTemplateType() == 2) {
            return BaseResponse.success((Object)rspBO);
        }
        String mapping = templatePO.getMapping();
        if (mapping == null) {
            return BaseResponse.fail((String)"\u901a\u7528\u6a21\u677f\u672a\u914d\u7f6e");
        }
        log.info("\u627e\u5230\u6a21\u677f\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)templatePO.getMapping()));
        List fieldDataBOS = null;
        try {
            fieldDataBOS = JSON.parseArray((String)mapping, FieldDataBO.class);
        }
        catch (Exception e) {
            log.error("\u6a21\u677f\u8f6c\u6362BO\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return BaseResponse.fail((String)"\u901a\u7528\u6a21\u677f\u683c\u5f0f\u914d\u7f6e\u9519\u8bef");
        }
        rspBO.setMappingList(fieldDataBOS);
        return BaseResponse.success((Object)rspBO);
    }

    private String checkParam(TempTemplateQryFieldReqBO reqBO) {
        if (reqBO.getFunctionId() == null && StringUtils.isEmpty((Object)reqBO.getFunctionCode())) {
            return "\u5165\u53c2\u3010functionId\u3011\u6216\u3010functionCode\u3011\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

