/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.console.controller.task;

import com.alibaba.fastjson.JSON;
import com.ohaotian.filedownload.console.service.business.TaskBusiness;
import com.ohaotian.filedownload.core.aspect.WebLog;
import com.ohaotian.filedownload.core.common.BaseResponse;
import com.ohaotian.filedownload.core.enums.TriggerModeEnum;
import com.ohaotian.filedownload.core.model.task.request.TaskDefinitionReqVO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fileDownloadPlatform/api/task"})
public class ApiTaskController {
    private static final Logger log = LoggerFactory.getLogger(ApiTaskController.class);
    @Autowired
    private TaskBusiness taskBusiness;

    @PostMapping(value={"/commit"})
    @WebLog(description="API\u4e0b\u8f7d\u4efb\u52a1\u63d0\u4ea4")
    public BaseResponse commitTask(@RequestBody @Validated(value={TaskDefinitionReqVO.Commit.class}) TaskDefinitionReqVO taskCommitReqBO) {
        log.info("\u4e0b\u8f7d\u4efb\u52a1\u63d0\u4ea4\u63a5\u53e3\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)taskCommitReqBO));
        taskCommitReqBO.setTriggerMode(TriggerModeEnum.API);
        return this.taskBusiness.commitTask(taskCommitReqBO);
    }

    @PostMapping(value={"/progress"})
    @WebLog(description="API\u4e0b\u8f7d\u4efb\u52a1\u8fdb\u5ea6\u67e5\u8be2")
    public BaseResponse queryTaskProgress(@RequestBody @Validated(value={TaskDefinitionReqVO.Progress.class}) TaskDefinitionReqVO taskProgressReqBO) {
        return this.taskBusiness.queryTaskProgress(taskProgressReqBO, true);
    }

    @PostMapping(value={"/progresslist"})
    @WebLog(description="API\u591a\u4e2a\u4e0b\u8f7d\u4efb\u52a1\u8fdb\u5ea6\u67e5\u8be2")
    public BaseResponse batchQueryTaskProgress(@RequestBody List<TaskDefinitionReqVO> taskProgressReqBOList) {
        return this.taskBusiness.batchQueryTaskProgress(taskProgressReqBOList, true);
    }

    @GetMapping(value={"/interrupt"})
    @WebLog(description="API\u4e0b\u8f7d\u4efb\u52a1\u4e2d\u65ad")
    public BaseResponse batchQueryTaskProgress(@RequestParam Long taskId, @RequestParam(defaultValue="api\u5c1d\u8bd5\u4e2d\u65ad") String message) {
        this.taskBusiness.tryInterrupt(taskId, message);
        return BaseResponse.success((Object)"\u6b63\u5728\u5c1d\u8bd5\u4e2d\u65ad...");
    }
}

