/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.console.controller.task;

import com.ohaotian.filedownload.console.service.business.TaskBusiness;
import com.ohaotian.filedownload.core.aspect.WebLog;
import com.ohaotian.filedownload.core.common.BaseResponse;
import com.ohaotian.filedownload.core.enums.TriggerModeEnum;
import com.ohaotian.filedownload.core.model.task.request.TaskDefinitionReqVO;
import com.ohaotian.filedownload.core.model.task.request.TaskQueryReqVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/fileDownloadPlatform/task"})
public class TaskController {
    @Autowired
    private TaskBusiness taskBusiness;

    @PostMapping(value={"/commit"})
    @WebLog(description="\u4e0b\u8f7d\u4efb\u52a1\u63d0\u4ea4")
    public BaseResponse commitFileTask(@RequestBody @Validated(value={TaskDefinitionReqVO.NonApiCommit.class}) TaskDefinitionReqVO taskCommitReqBO) {
        taskCommitReqBO.setTriggerMode(TriggerModeEnum.PAGE);
        taskCommitReqBO.setMenuPath(TriggerModeEnum.PAGE.getDesc());
        return this.taskBusiness.commitTask(taskCommitReqBO);
    }

    @PostMapping(value={"/list"})
    @WebLog(description="\u4e0b\u8f7d\u4efb\u52a1\u5217\u8868")
    public BaseResponse queryTaskList(@RequestBody TaskQueryReqVO taskQueryReqVO) {
        return this.taskBusiness.queryTaskListPageable(taskQueryReqVO);
    }

    @PostMapping(value={"/detail"})
    @WebLog(description="\u4e0b\u8f7d\u4efb\u52a1\u8be6\u60c5")
    public BaseResponse queryTaskDetail(@RequestBody @Validated(value={TaskDefinitionReqVO.Progress.class}) TaskDefinitionReqVO taskDetailReqBO) {
        return this.taskBusiness.queryTaskDetail(taskDetailReqBO, false);
    }
}

