/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.console.service.business;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.filedownload.common.utils.HttpUtil;
import com.ohaotian.filedownload.console.service.notice.SendNoticeCenterMsgService;
import com.ohaotian.filedownload.console.service.task.TaskService;
import com.ohaotian.filedownload.console.service.user.UserService;
import com.ohaotian.filedownload.core.common.Consts;
import com.ohaotian.filedownload.core.enums.PluginFileTypeEnum;
import com.ohaotian.filedownload.core.enums.TargetFileTypeEnum;
import com.ohaotian.filedownload.core.enums.TaskStatusEnum;
import com.ohaotian.filedownload.core.exception.FDSException;
import com.ohaotian.filedownload.core.exception.FDSResponseInfoEnum;
import com.ohaotian.filedownload.core.model.business.bo.DownladTask;
import com.ohaotian.filedownload.core.model.business.bo.TaskIdentity;
import com.ohaotian.filedownload.core.model.business.bo.TaskProgress;
import com.ohaotian.filedownload.core.model.function.response.FunctionDefineRspVO;
import com.ohaotian.filedownload.core.model.notice.response.SncMsgRspVO;
import com.ohaotian.filedownload.core.model.task.request.TaskDownloadRecordDataBO;
import com.ohaotian.filedownload.core.model.task.request.TaskDownloadRecordListReqBO;
import com.ohaotian.filedownload.core.util.Profiler;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsConfig;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.ohaotian.plugin.file.obs.ObsConfig;
import com.ohaotian.plugin.file.oss.OssConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TaskMasterService {
    private static final Logger log = LoggerFactory.getLogger(TaskMasterService.class);
    private static final ConcurrentHashMap<Long, DownladTask> RUNNING_TASK_POOL = new ConcurrentHashMap();
    private static DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static AtomicLong atomicTimeMills = new AtomicLong(0L);
    @Value(value="${plugin.file.type}")
    private String pluginFileType;
    @Value(value="${fastdfs.accessUrl:}")
    private String fastdfsAccessUrl;
    @Value(value="${download.task.callback.address:1}")
    private String callbackUrl;
    @Value(value="${download.task.callback.switch:0}")
    private String isCallback;
    private final String IS_CALLBACK_NO = "0";
    private final String IS_CALLBACK_YES = "1";
    @Autowired
    private OssConfig ossConfig;
    @Autowired
    private FastdfsConfig fastdfsConfig;
    @Autowired
    private ObsConfig obsConfig;
    @Autowired
    private TaskService taskService;
    @Autowired
    private SendNoticeCenterMsgService sendNoticeCenterMsgService;
    @Autowired
    private UserService userService;
    @Autowired
    private FileClient fileClient;
    @Autowired
    private ExecutorService partitionDownloadPool;

    private static String getFormatTime() {
        long currentMill;
        long currentTimeMillis;
        while ((currentTimeMillis = Long.parseLong(LocalDateTime.now().format(formatter))) <= (currentMill = atomicTimeMills.get()) || !atomicTimeMills.compareAndSet(currentMill, currentTimeMillis)) {
        }
        return Long.toString(currentTimeMillis);
    }

    public void downloadTask(String taskIdentityJson) {
        Profiler.begin();
        DownladTask downladTask = new DownladTask(taskIdentityJson);
        RUNNING_TASK_POOL.put(downladTask.getTaskIdentity().getTaskId(), downladTask);
        try {
            String filePath = downladTask.execute(RUNNING_TASK_POOL.size(), this.partitionDownloadPool);
            this.onSuccess(filePath, downladTask);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error("## \u4efb\u52a1\u5206\u7247\u6267\u884c\u5f02\u5e38\uff0c\u6b63\u5728\u7ec8\u6b62\u8be5\u4efb\u52a1\u5176\u4ed6\u7ebf\u7a0b\u3002e\uff1a{}", (Throwable)e);
            this.tryInterrupt(downladTask, e.getMessage());
            throw new FDSException("## \u4efb\u52a1\u5206\u7247\u6267\u884c\u5f02\u5e38\uff0c\u6b63\u5728\u7ec8\u6b62\u8be5\u4efb\u52a1\u5176\u4ed6\u7ebf\u7a0b:" + e.getMessage());
        }
        catch (Throwable t) {
            log.error("\u4efb\u52a1\u5931\u8d25\u3002taskId:{}, ex:{}", (Object)downladTask.getTaskIdentity().getTaskId(), (Object)t);
            this.onFail(downladTask.getTaskIdentity().getTaskId(), t.getMessage());
            throw new FDSException("\u4efb\u52a1\u3010" + downladTask.getTaskIdentity().getTaskId() + "\u3011\u5931\u8d25\u3002" + t);
        }
    }

    public TaskProgress queryProgress(Long taskId) {
        DownladTask downladTask = RUNNING_TASK_POOL.get(taskId);
        if (downladTask == null || downladTask.getTaskProgress() == null) {
            return new TaskProgress();
        }
        TaskProgress taskProgress = downladTask.getTaskProgress();
        return TaskProgress.builder().taskId(taskProgress.getTaskId()).successTotal(taskProgress.getSuccessTotal()).taskStatus(taskProgress.getTaskStatus()).total(taskProgress.getTotal()).build();
    }

    public void tryInterrupt(Long taskId, String message) {
        DownladTask downladTask = RUNNING_TASK_POOL.get(taskId);
        if (downladTask == null) {
            return;
        }
        this.tryInterrupt(downladTask, message);
    }

    private void tryInterrupt(DownladTask downladTask, String message) {
        Long taskId = downladTask.getTaskIdentity().getTaskId();
        log.error("## \u4efb\u52a1\uff1a{}\uff0c\u5f00\u59cb\u5c1d\u8bd5\u4e2d\u65ad\u3002", (Object)taskId);
        List futureResults = downladTask.getFutureResults();
        for (Future future : futureResults) {
            future.cancel(true);
        }
        this.onFail(taskId, message);
        this.deleteTmpFileDir(downladTask.getTaskIdentity().getTempFileDirForGeneral());
    }

    private void deleteTmpFileDir(String sourcePath) {
        try {
            File tmpFileDir = new File(sourcePath);
            if (tmpFileDir.exists()) {
                FileUtils.forceDelete((File)tmpFileDir);
            }
            log.info("## \u4e34\u65f6\u6587\u4ef6\u5939\u5220\u9664\u6210\u529f\uff0cpath\uff1a" + sourcePath);
        }
        catch (IOException e) {
            log.warn("## \u4e34\u65f6\u6587\u4ef6\u5939\u88ab\u5360\u7528\uff0c\u5220\u9664\u5931\u8d25  ", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String uploadToFileServer(String targetFilePath, DownladTask downladTask) {
        try (FileInputStream fis = new FileInputStream(targetFilePath);){
            String fileName = this.generateFileName(downladTask.getTaskIdentity());
            String path = this.fileClient.uploadFileByInputStream(Consts.FILE_SERVICE_PATH, fileName, (InputStream)fis);
            String string = this.uploadFileUrl(fileName, path);
            return string;
        }
        catch (IOException e) {
            log.error("\u4e0a\u4f20\u6587\u4ef6\u5230\u6587\u4ef6\u670d\u52a1\u5668\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new FDSException("\u4e0a\u4f20\u6587\u4ef6\u5230\u6587\u4ef6\u670d\u52a1\u5668\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private String uploadFileUrl(String fileName, String path) {
        String url;
        switch (PluginFileTypeEnum.codeOf((String)this.pluginFileType)) {
            case FASTDFS: {
                FastdfsFileInfo fileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                String groupName = fileInfo.getGroupName();
                String fastdfsFileName = fileInfo.getFileName();
                url = this.fastdfsAccessUrl + ":" + this.fastdfsConfig.getHttpTrackerHttpPort() + "/" + groupName + "/" + fastdfsFileName + "?attname=" + fileName;
                break;
            }
            case OBS: {
                url = this.obsConfig.getAccessUrl() + "/" + path;
                break;
            }
            default: {
                url = this.ossConfig.getAccessUrl() + "/" + path;
            }
        }
        log.info("## \u4e0a\u4f20\u6587\u4ef6\u5730\u5740: {}", (Object)url);
        return url;
    }

    private String generateFileName(TaskIdentity taskIdentity) {
        String functionName = taskIdentity.getFunctionDefineRspVO().getFunctionName();
        if (!StringUtils.isEmpty((Object)taskIdentity.getTabCode())) {
            functionName = functionName + "(" + taskIdentity.getTabCode() + ")";
        }
        String fileNamePrefix = String.format("%s%s", functionName, TaskMasterService.getFormatTime());
        if (!StringUtils.isEmpty((Object)taskIdentity.getExportFileName())) {
            fileNamePrefix = taskIdentity.getExportFileName();
        }
        Integer templateType = taskIdentity.getTemplatePO().getTemplateType();
        if (TargetFileTypeEnum.EXCEL.getCode().equals(taskIdentity.getTemplatePO().getTargetFileType())) {
            return fileNamePrefix + ".xlsx";
        }
        if (TargetFileTypeEnum.PDF.getCode().equals(taskIdentity.getTemplatePO().getTargetFileType())) {
            return fileNamePrefix + ".pdf";
        }
        if (TargetFileTypeEnum.ZIP.getCode().equals(taskIdentity.getTemplatePO().getTargetFileType())) {
            return fileNamePrefix + ".zip";
        }
        if (TargetFileTypeEnum.EXCEL_COMPLEX.getCode().equals(taskIdentity.getTemplatePO().getTargetFileType())) {
            return fileNamePrefix + ".zip";
        }
        if (TargetFileTypeEnum.NIMBLE.getCode().equals(taskIdentity.getTemplatePO().getTargetFileType())) {
            return fileNamePrefix + ".xlsx";
        }
        throw new FDSException("\u76ee\u6807\u6587\u4ef6\u7c7b\u578b\u5f02\u5e38");
    }

    private void invokeNoticeCenter(DownladTask downladTask, String url) throws FDSException {
        FunctionDefineRspVO functionDefineRspVO = downladTask.getTaskIdentity().getFunctionDefineRspVO();
        if (!CollectionUtils.isEmpty((Collection)functionDefineRspVO.getNoticeConfigIds())) {
            String phoneNum;
            String mail;
            try {
                log.info("## userId: {}", (Object)downladTask.getTaskIdentity().getUserId());
                Map<String, Object> resultMap = this.userService.getUserInfo(downladTask.getTaskIdentity().getUserId());
                log.info("## resultMap: {}", resultMap);
                mail = (String)((Map)resultMap.get("data")).get("email");
                phoneNum = (String)((Map)resultMap.get("data")).get("cellPhone");
                log.info("## mail: {}, phoneNum: {}", (Object)mail, (Object)phoneNum);
            }
            catch (Exception e) {
                log.error("## \u8c03\u7528\u6743\u9650\u4e2d\u5fc3\uff0c\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5f02\u5e38. ex: {}", (Throwable)e);
                throw new FDSException(FDSResponseInfoEnum.NOTICE_CENTER_GET_USER_INFO_ERROR);
            }
            String jsonStr = this.getMsgString(downladTask, url, functionDefineRspVO);
            Iterator iterator = functionDefineRspVO.getNoticeConfigIds().iterator();
            while (iterator.hasNext()) {
                long noticeCenterId = (Long)iterator.next();
                SncMsgRspVO sncMsgRspVO = this.sendNoticeCenterMsgService.sendMsgByConfigId(noticeCenterId, jsonStr, phoneNum, mail);
                log.info("## \u8c03\u7528\u901a\u77e5\u4e2d\u5fc3{}\u6210\u529f code: {}, message: {}", new Object[]{noticeCenterId, sncMsgRspVO.getCode(), sncMsgRspVO.getMessage()});
            }
        }
    }

    private String getMsgString(DownladTask downladTask, String url, FunctionDefineRspVO functionDefineRspVO) {
        JSONObject json = new JSONObject();
        json.put("taskId", (Object)downladTask.getTaskIdentity().getTaskId());
        json.put("taskName", (Object)downladTask.getTaskIdentity().getTaskName());
        json.put("businessCenterId", (Object)functionDefineRspVO.getBusinessCenterId());
        json.put("serviceName", (Object)functionDefineRspVO.getServiceDefineRspVO().getServiceName());
        json.put("serviceDesc", (Object)functionDefineRspVO.getServiceDefineRspVO().getServiceDesc());
        json.put("serviceAddress", (Object)functionDefineRspVO.getServiceDefineRspVO().getHttpConfig().getServiceAddress());
        json.put("requestParam", (Object)functionDefineRspVO.getServiceDefineRspVO().getHttpConfig().getRequestParam());
        json.put("url", (Object)url);
        return json.toJSONString();
    }

    private void onSuccess(String targetFilePath, DownladTask downladTask) {
        String fileUrl = this.uploadToFileServer(targetFilePath, downladTask);
        DownladTask remove = RUNNING_TASK_POOL.remove(downladTask.getTaskIdentity().getTaskId());
        if (remove == null || remove.getTaskProgress() == null) {
            throw new FDSException(FDSResponseInfoEnum.TASK_PROGRESS_UPDATE_EXCEPTION);
        }
        TaskProgress taskProgress = remove.getTaskProgress();
        taskProgress.setTaskStatus(Integer.valueOf(TaskStatusEnum.SUCCESS.getCode()));
        taskProgress.setFilePath(fileUrl);
        taskProgress.setCompleteTime(LocalDateTime.now());
        this.taskService.updateTaskProgress(taskProgress);
        log.info("## \u4efb\u52a1\u4e0b\u8f7d\u6210\u529f\u3002\u72b6\u6001\u5df2\u66f4\u65b0: taskId\uff1a{}\uff0c\u603b\u8017\u65f6\uff1a{}ms", (Object)downladTask.getTaskIdentity().getTaskId(), (Object)Profiler.end());
        try {
            this.invokeNoticeCenter(downladTask, fileUrl);
        }
        catch (Exception e) {
            log.error("## \u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u5931\u8d25. ex: {}", (Throwable)e);
        }
        if (StringUtils.isEmpty((Object)downladTask.getTaskIdentity().getTaskId()) || StringUtils.isEmpty((Object)taskProgress.getTaskStatus())) {
            throw new FDSException(FDSResponseInfoEnum.TASK_CALLBACK_FAILED_EXCEPTION);
        }
        this.taskStatusCallback(downladTask.getTaskIdentity().getTaskId(), taskProgress.getTaskStatus());
        try {
            String targetFilePathExtZip;
            File file;
            FileUtils.forceDelete((File)new File(targetFilePath));
            if (targetFilePath.endsWith(".zip") && (file = new File(targetFilePathExtZip = targetFilePath.replace(".zip", ""))).exists()) {
                FileUtils.forceDelete((File)new File(targetFilePathExtZip));
                log.info("## \u672c\u5730\u6587\u4ef6\u5df2\u5220\u9664\u3002 targetFilePathExtZip\uff1a{}", (Object)targetFilePathExtZip);
            }
            log.info("## \u672c\u5730\u6587\u4ef6\u5df2\u5220\u9664\u3002 targetFilePath\uff1a{}", (Object)targetFilePath);
        }
        catch (IOException e) {
            log.error("## \u5220\u9664\u6587\u4ef6\u5931\u8d25\u3002ex: {}", (Object)e.getMessage());
        }
    }

    private void onFail(Long taskId, String message) {
        log.error("\u4efb\u52a1\u4e0b\u8f7d\u5931\u8d25\u3002taskId:{},message:{}", (Object)taskId, (Object)message);
        DownladTask remove = RUNNING_TASK_POOL.remove(taskId);
        TaskProgress taskProgress = remove == null || remove.getTaskProgress() == null ? TaskProgress.builder().build() : remove.getTaskProgress();
        taskProgress.setTaskId(taskId);
        taskProgress.setFailReason(message);
        taskProgress.setTaskStatus(Integer.valueOf(TaskStatusEnum.FAIL.getCode()));
        this.taskService.updateTaskProgress(taskProgress);
        log.info("\u4efb\u52a1\u72b6\u6001\u5df2\u66f4\u65b0\u4e3a\uff1a\u5931\u8d25\u3002");
        this.taskStatusCallback(taskId, TaskStatusEnum.FAIL.getCode());
    }

    private void taskStatusCallback(Long taskId, int callBackStatus) {
        JSONObject paramJson = new JSONObject();
        if ("1".equals(this.isCallback)) {
            ArrayList<TaskDownloadRecordDataBO> taskDownloadRecordDataBOList = new ArrayList<TaskDownloadRecordDataBO>();
            TaskDownloadRecordDataBO taskDownloadRecordDataBO = new TaskDownloadRecordDataBO();
            taskDownloadRecordDataBO.setTaskId(String.valueOf(taskId));
            taskDownloadRecordDataBO.setTaskStatus(String.valueOf(callBackStatus));
            taskDownloadRecordDataBOList.add(taskDownloadRecordDataBO);
            TaskDownloadRecordListReqBO taskDownloadRecordListReqBO = new TaskDownloadRecordListReqBO();
            taskDownloadRecordListReqBO.setUpdateTaskBOS(taskDownloadRecordDataBOList);
            log.info("\u56de\u8c03\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)taskDownloadRecordListReqBO));
            String result = "";
            try {
                result = HttpUtil.doPost((String)this.callbackUrl, (String)JSON.toJSONString((Object)taskDownloadRecordListReqBO));
                log.info("\u56de\u8c03\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)result);
            }
            catch (Exception e) {
                log.info("\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)e.toString());
                throw new FDSException(FDSResponseInfoEnum.TASK_CALLBACK_FAILED_EXCEPTION);
            }
        }
    }
}

