/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.console.service.business.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.filedownload.console.schedule.TaskDownloadJob;
import com.ohaotian.filedownload.console.service.business.TaskBusiness;
import com.ohaotian.filedownload.console.service.business.TaskMasterService;
import com.ohaotian.filedownload.console.service.function.FunctionDefineService;
import com.ohaotian.filedownload.console.service.service.ServiceDefineService;
import com.ohaotian.filedownload.console.service.task.TaskService;
import com.ohaotian.filedownload.console.service.template.TemplateService;
import com.ohaotian.filedownload.console.service.tepmtepmlate.TempTemplateQryService;
import com.ohaotian.filedownload.core.common.BaseResponse;
import com.ohaotian.filedownload.core.common.PageQueryResponse;
import com.ohaotian.filedownload.core.dao.entity.TaskPO;
import com.ohaotian.filedownload.core.dao.entity.TemplatePO;
import com.ohaotian.filedownload.core.enums.PluginFileTypeEnum;
import com.ohaotian.filedownload.core.enums.TriggerModeEnum;
import com.ohaotian.filedownload.core.exception.FDSException;
import com.ohaotian.filedownload.core.exception.FDSResponseInfoEnum;
import com.ohaotian.filedownload.core.model.business.bo.TaskIdentity;
import com.ohaotian.filedownload.core.model.function.response.FunctionDefineRspVO;
import com.ohaotian.filedownload.core.model.service.response.ServiceDefineRspVO;
import com.ohaotian.filedownload.core.model.task.request.TaskDefinitionReqVO;
import com.ohaotian.filedownload.core.model.task.request.TaskQueryReqVO;
import com.ohaotian.filedownload.core.model.task.response.TaskDetailRspVO;
import com.ohaotian.filedownload.core.model.temptemplate.bo.MappingDataBO;
import com.ohaotian.filedownload.core.model.temptemplate.bo.TempTemplateQryDetailReqBO;
import com.ohaotian.filedownload.core.model.temptemplate.bo.TempTemplateQryDetailRspBO;
import com.ohaotian.filedownload.core.util.IDUtils;
import com.ohaotian.plugin.file.fastdfs.FastdfsConfig;
import com.ohaotian.plugin.file.oss.OssConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TaskBusinessImpl
implements TaskBusiness {
    private static final Logger log = LoggerFactory.getLogger(TaskBusinessImpl.class);
    @Autowired
    private TaskMasterService taskMasterService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ServiceDefineService serviceDefineService;
    @Autowired
    private FunctionDefineService functionDefineService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private Scheduler scheduler;
    @Autowired
    private ExecutorService taskDownloadPool;
    @Autowired
    private IDUtils idUtils;
    @Value(value="${file.tmpDir}")
    private String fileTmpDir;
    @Value(value="${file.templateDirPath}")
    private String fileTemplateDirPath;
    @Autowired
    private OssConfig ossConfig;
    @Autowired
    private FastdfsConfig fastdfsConfig;
    @Value(value="${plugin.file.type}")
    private String pluginFileType;
    @Value(value="${fastdfs.accessUrl:}")
    private String fastdfsAccessUrl;
    @Autowired
    private TempTemplateQryService tempTemplateQryService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseResponse commitTask(TaskDefinitionReqVO taskDefinitionReqVO) {
        log.info("TaskDefinitionReqVO:{}", (Object)JSON.toJSONString((Object)taskDefinitionReqVO));
        taskDefinitionReqVO.validateApiCommit();
        taskDefinitionReqVO.checkCronExpression();
        FunctionDefineRspVO functionDefineRspVO = this.queryFunctionDetail(taskDefinitionReqVO);
        TaskPO taskPo = functionDefineRspVO.convertToTaskBO(taskDefinitionReqVO);
        if (!StringUtils.isEmpty((Object)taskDefinitionReqVO.getMenuPath())) {
            taskPo.setMenuPath(taskDefinitionReqVO.getMenuPath());
        }
        this.taskService.insertNewTask(taskPo);
        TemplatePO templatePo = this.templateService.findById(functionDefineRspVO.getTemplateId());
        if (taskDefinitionReqVO.getTempTemplateId() != null && taskDefinitionReqVO.getTempTemplateId() > 0) {
            TempTemplateQryDetailReqBO qryReqBO = new TempTemplateQryDetailReqBO();
            qryReqBO.setTemplateId(taskDefinitionReqVO.getTempTemplateId());
            BaseResponse<TempTemplateQryDetailRspBO> tempTemplateQryDetailRspBOBaseResponse = this.tempTemplateQryService.qryDetail(qryReqBO);
            TempTemplateQryDetailRspBO data = (TempTemplateQryDetailRspBO)tempTemplateQryDetailRspBOBaseResponse.getData();
            templatePo.setMapping(JSON.toJSONString((Object)data.getMappingList()));
            functionDefineRspVO.setFunctionName(data.getFileName());
        }
        if (!StringUtils.isEmpty((Object)taskDefinitionReqVO.getMappingList())) {
            templatePo.setMapping(taskDefinitionReqVO.getMappingList());
        }
        this.setHeadOne(templatePo);
        TaskIdentity taskIdentity = TaskIdentity.builder().userId(taskDefinitionReqVO.getUserId()).tabCode(taskDefinitionReqVO.getTabCode()).taskId(taskPo.getTaskId()).taskName(taskPo.getTaskName()).fileTmpDir(this.fileTmpDir).functionDefineRspVO(functionDefineRspVO).templatePO(templatePo).exportFileName(taskDefinitionReqVO.getExportFileName()).build();
        switch (PluginFileTypeEnum.codeOf((String)this.pluginFileType)) {
            case FASTDFS: {
                String fastdfsUrl = this.fastdfsAccessUrl + ":" + this.fastdfsConfig.getHttpTrackerHttpPort();
                taskIdentity.setFileTemplateDirPath(fastdfsUrl);
                break;
            }
            default: {
                taskIdentity.setFileTemplateDirPath(this.ossConfig.getAccessUrl());
            }
        }
        this.commitTask(taskIdentity);
        return BaseResponse.success((Object)taskPo);
    }

    public BaseResponse<PageQueryResponse> queryTaskListPageable(TaskQueryReqVO taskQueryReqVO) {
        taskQueryReqVO.confirmAuthority();
        Page page = PageMethod.startPage((int)taskQueryReqVO.getPageNo(), (int)taskQueryReqVO.getPageSize());
        List<TaskDetailRspVO> taskDetailRspVoS = this.taskService.queryTaskList(taskQueryReqVO);
        return PageQueryResponse.success((Page)page, taskDetailRspVoS);
    }

    @Override
    public BaseResponse queryTaskDetail(TaskDefinitionReqVO taskDefinitionReqVO, boolean isApiQuery) {
        TaskDetailRspVO taskDetailRspVO = this.taskService.queryTask(taskDefinitionReqVO, isApiQuery);
        return BaseResponse.success((Object)taskDetailRspVO);
    }

    @Override
    public BaseResponse queryTaskProgress(TaskDefinitionReqVO taskDefinitionReqVO, boolean isApiQuery) {
        return BaseResponse.success((Object)this.taskService.queryTask(taskDefinitionReqVO, isApiQuery));
    }

    @Override
    public BaseResponse batchQueryTaskProgress(List<TaskDefinitionReqVO> taskDefinitionReqVOList, boolean isApiQuery) {
        ArrayList<TaskDetailRspVO> collect = new ArrayList<TaskDetailRspVO>();
        for (TaskDefinitionReqVO taskProgressReqBO : taskDefinitionReqVOList) {
            Objects.requireNonNull(taskProgressReqBO.getTaskId(), "\u4efb\u52a1id[taskId]\u4e0d\u80fd\u4e3a\u7a7a");
            collect.add(this.taskService.queryTask(taskProgressReqBO, isApiQuery));
        }
        return BaseResponse.success(collect);
    }

    @Override
    public void tryInterrupt(Long taskId, String message) {
        this.taskMasterService.tryInterrupt(taskId, message);
    }

    private void commitTask(TaskIdentity taskIdentity) {
        switch (taskIdentity.selectDownloadTaskMode()) {
            case REAL_TIME: {
                CompletableFuture.runAsync(() -> this.taskMasterService.downloadTask(JSON.toJSONString((Object)taskIdentity)), this.taskDownloadPool);
                break;
            }
            case DELAY: {
                this.submitScheduleJob(taskIdentity);
                break;
            }
            default: {
                log.error("## \u5339\u914d\u4e0b\u8f7d\u6a21\u5f0f\u5931\u8d25: {}", (Object)FDSResponseInfoEnum.UN_SUPPORT_ERROR.getErrorMsg());
                throw new FDSException(FDSResponseInfoEnum.UN_SUPPORT_ERROR);
            }
        }
    }

    private void submitScheduleJob(TaskIdentity taskIdentity) {
        JobDetail jobDetail = JobBuilder.newJob(TaskDownloadJob.class).withIdentity(this.generateNameFor("JOB-%s"), "GROUP").usingJobData("IDENTITY", JSON.toJSONString((Object)taskIdentity)).build();
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)taskIdentity.getFunctionDefineRspVO().getCronExpression());
        CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(this.generateNameFor("TRIGGER-%s"), "GROUP").withSchedule((ScheduleBuilder)scheduleBuilder).build();
        try {
            this.scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
        }
        catch (SchedulerException e) {
            log.error("## \u6dfb\u52a0\u8c03\u5ea6\u4efb\u52a1\u5931\u8d25. ex: {}", (Throwable)e);
            throw new FDSException(FDSResponseInfoEnum.COMMIT_TASK_FAIL);
        }
    }

    private String generateNameFor(String formatTriggerName) {
        return String.format(formatTriggerName, this.idUtils.generateTraceId());
    }

    private FunctionDefineRspVO queryFunctionDetail(TaskDefinitionReqVO taskDefinitionReqVO) {
        List functionIds = taskDefinitionReqVO.getFunctionIds();
        String functionCode = taskDefinitionReqVO.getFunctionCode();
        Long functionId = null;
        if (!CollectionUtils.isEmpty((Collection)functionIds)) {
            functionId = (Long)functionIds.get(0);
        }
        FunctionDefineRspVO functionDefineRspVO = this.functionDefineService.findByIdOrCode(functionId, functionCode);
        ServiceDefineRspVO serviceDefineRspVO = this.serviceDefineService.queryServiceDetail(functionDefineRspVO.getServiceId());
        if (Objects.equals(TriggerModeEnum.API, taskDefinitionReqVO.getTriggerMode())) {
            serviceDefineRspVO.addHttpRequestParam(taskDefinitionReqVO.getRequestParam());
        }
        functionDefineRspVO.setServiceDefineRspVO(serviceDefineRspVO);
        return functionDefineRspVO;
    }

    private void setHeadOne(TemplatePO templatePO) {
        MappingDataBO mappingDataBO;
        List mappingDataBOS;
        ArrayList<MappingDataBO> newMapping = new ArrayList<MappingDataBO>();
        String mapping = templatePO.getMapping();
        if (!(StringUtils.isEmpty((Object)mapping) || CollectionUtils.isEmpty((Collection)(mappingDataBOS = JSON.parseArray((String)mapping, MappingDataBO.class))) || "\u5e8f\u53f7".equals((mappingDataBO = (MappingDataBO)mappingDataBOS.get(0)).getHeadName()))) {
            MappingDataBO dataBO = new MappingDataBO();
            dataBO.setHeadOrder(Integer.valueOf(1));
            dataBO.setHeadName("\u5e8f\u53f7");
            dataBO.setRspKey("");
            newMapping.add(dataBO);
            for (MappingDataBO bo : mappingDataBOS) {
                bo.setHeadOrder(Integer.valueOf(bo.getHeadOrder() + 1));
                newMapping.add(bo);
            }
            templatePO.setMapping(JSON.toJSONString(newMapping));
        }
    }
}

