/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.console.service.function.impl;

import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.filedownload.console.service.function.FunctionDefineService;
import com.ohaotian.filedownload.core.common.BaseResponse;
import com.ohaotian.filedownload.core.common.PageQueryResponse;
import com.ohaotian.filedownload.core.dao.entity.FunctionDefinePO;
import com.ohaotian.filedownload.core.dao.entity.ServiceDefinePO;
import com.ohaotian.filedownload.core.dao.entity.TemplatePO;
import com.ohaotian.filedownload.core.dao.mapper.FunctionDefinePOMapper;
import com.ohaotian.filedownload.core.dao.mapper.NoticeCenterConfigPOMapper;
import com.ohaotian.filedownload.core.dao.mapper.ServiceDefinePOMapper;
import com.ohaotian.filedownload.core.dao.mapper.TemplatePOMapper;
import com.ohaotian.filedownload.core.exception.FDSException;
import com.ohaotian.filedownload.core.exception.FDSResponseInfoEnum;
import com.ohaotian.filedownload.core.model.function.request.FunctionDefinitionReqVO;
import com.ohaotian.filedownload.core.model.function.request.FunctionQueryVO;
import com.ohaotian.filedownload.core.model.function.response.FunctionDefineRspVO;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dozer.Mapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FunctionDefineServiceImpl
implements FunctionDefineService {
    @Autowired
    private FunctionDefinePOMapper functionDefineMapper;
    @Autowired
    private ServiceDefinePOMapper serviceDefineMapper;
    @Autowired
    private NoticeCenterConfigPOMapper noticeCenterConfigMapper;
    @Autowired
    private TemplatePOMapper templateMapper;
    @Autowired
    private Mapper mapper;

    @Override
    public FunctionDefineRspVO queryFunction(Long functionId) {
        FunctionDefinePO functionDefinePo = this.functionDefineMapper.selectByPrimaryKey(functionId);
        if (functionDefinePo == null) {
            throw new FDSException(FDSResponseInfoEnum.FUNCTION_NOT_EXIST);
        }
        FunctionDefineRspVO functionDefineRspVO = (FunctionDefineRspVO)this.mapper.map((Object)functionDefinePo, FunctionDefineRspVO.class);
        functionDefineRspVO.setNoticeConfigIds(this.splitToList(functionDefinePo.getNoticeConfigIds()));
        functionDefineRspVO.setUserId(functionDefinePo.getCreateUserId());
        if (functionDefinePo.getServiceId() != null) {
            ServiceDefinePO serviceDefinePo = this.serviceDefineMapper.selectByPrimaryKey(functionDefinePo.getServiceId());
            functionDefineRspVO.setServiceName(serviceDefinePo.getServiceName());
        }
        if (functionDefinePo.getTemplateId() != null) {
            TemplatePO templatePo = this.templateMapper.selectByPrimaryKey(functionDefinePo.getTemplateId());
            functionDefineRspVO.setTemplateName(templatePo.getTemplateName());
        }
        if (!CollectionUtils.isEmpty((Collection)functionDefineRspVO.getNoticeConfigIds())) {
            List descriptions = this.noticeCenterConfigMapper.queryDescriptionsByIds(functionDefineRspVO.getNoticeConfigIds());
            functionDefineRspVO.setDescriptions(StringUtils.join((Iterable)descriptions, (String)";"));
        }
        return functionDefineRspVO;
    }

    @Override
    public FunctionDefineRspVO queryNoticeConfigIdsByFunctionId(Long functionId) {
        FunctionDefinePO functionDefinePo = this.functionDefineMapper.selectByPrimaryKey(functionId);
        return FunctionDefineRspVO.builder().noticeConfigIds(this.splitToList(functionDefinePo.getNoticeConfigIds())).build();
    }

    @Override
    public Optional<FunctionDefinePO> findBy(Long functionId) {
        return Optional.ofNullable(this.functionDefineMapper.selectByPrimaryKey(functionId));
    }

    @Override
    public BaseResponse<PageQueryResponse> queryPageableFunctionList(FunctionQueryVO functionQueryVO) {
        functionQueryVO.queryLikeByFunctionName();
        PageInfo pageInfo = PageMethod.startPage((int)functionQueryVO.getPageNo(), (int)functionQueryVO.getPageSize()).doSelectPageInfo(() -> this.functionDefineMapper.queryFunctionDefinePageList(functionQueryVO, functionQueryVO.confirmAuthority().intValue()));
        return PageQueryResponse.success((PageInfo)pageInfo);
    }

    @Override
    public boolean saveFunction(FunctionDefinitionReqVO functionDefinitionReqVO) {
        FunctionDefinePO functionDefinePo = new FunctionDefinePO();
        functionDefinePo.setFunctionName(functionDefinitionReqVO.getFunctionName());
        List records = this.functionDefineMapper.findByPO(functionDefinePo);
        if (!CollectionUtils.isEmpty((Collection)records)) {
            throw new FDSException(FDSResponseInfoEnum.NAME_EXISTS_EXCEPTION);
        }
        if (StringUtils.isNotEmpty((CharSequence)functionDefinitionReqVO.getFunctionCode())) {
            functionDefinePo = new FunctionDefinePO();
            functionDefinePo.setFunctionCode(functionDefinitionReqVO.getFunctionCode());
            records = this.functionDefineMapper.findByPO(functionDefinePo);
            if (!CollectionUtils.isEmpty((Collection)records)) {
                throw new FDSException(FDSResponseInfoEnum.CODE_EXISTS_EXCEPTION);
            }
        }
        BeanUtils.copyProperties((Object)functionDefinitionReqVO, (Object)functionDefinePo);
        if (!CollectionUtils.isEmpty((Collection)functionDefinitionReqVO.getNoticeConfigIds())) {
            functionDefinePo.setNoticeConfigIds(functionDefinitionReqVO.getNoticeConfigIds().stream().map(String::valueOf).collect(Collectors.joining(",")));
        }
        functionDefinePo.setCreateTime(new Date());
        functionDefinePo.setCreateUserId(functionDefinitionReqVO.getUserId());
        this.functionDefineMapper.insertSelective(functionDefinePo);
        return true;
    }

    @Override
    public boolean updateFunction(FunctionDefinitionReqVO functionDefinitionReqVO) {
        FunctionDefinePO functionDefinePo = new FunctionDefinePO();
        functionDefinePo.setFunctionName(functionDefinitionReqVO.getFunctionName());
        List records = this.functionDefineMapper.findByPO(functionDefinePo);
        if (!CollectionUtils.isEmpty((Collection)records) && !((FunctionDefinePO)records.get(0)).getFunctionId().equals(functionDefinitionReqVO.getFunctionId())) {
            throw new FDSException(FDSResponseInfoEnum.NAME_EXISTS_EXCEPTION);
        }
        if (StringUtils.isNotEmpty((CharSequence)functionDefinitionReqVO.getFunctionCode())) {
            functionDefinePo = new FunctionDefinePO();
            functionDefinePo.setFunctionCode(functionDefinitionReqVO.getFunctionCode());
            records = this.functionDefineMapper.findByPO(functionDefinePo);
            if (!CollectionUtils.isEmpty((Collection)records) && !((FunctionDefinePO)records.get(0)).getFunctionId().equals(functionDefinitionReqVO.getFunctionId())) {
                throw new FDSException(FDSResponseInfoEnum.CODE_EXISTS_EXCEPTION);
            }
        }
        BeanUtils.copyProperties((Object)functionDefinitionReqVO, (Object)functionDefinePo);
        if (!CollectionUtils.isEmpty((Collection)functionDefinitionReqVO.getNoticeConfigIds())) {
            functionDefinePo.setNoticeConfigIds(functionDefinitionReqVO.getNoticeConfigIds().stream().map(String::valueOf).collect(Collectors.joining(",")));
        }
        functionDefinePo.setUpdateTime(new Date());
        functionDefinePo.setUpdateUserId(functionDefinitionReqVO.getUserId());
        this.functionDefineMapper.updateByPrimaryKeySelective(functionDefinePo);
        return true;
    }

    @Override
    public boolean delFunction(FunctionDefinitionReqVO functionDefinitionReqVO) {
        this.functionDefineMapper.deleteByPrimaryKey(functionDefinitionReqVO.getFunctionId());
        return true;
    }

    private List<Long> splitToList(String noticeConfigIds) {
        if (StringUtils.isBlank((CharSequence)noticeConfigIds)) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.stream(noticeConfigIds.split(",")).map(Long::valueOf).collect(Collectors.toList());
    }

    @Override
    public FunctionDefineRspVO findByIdOrCode(Long functionId, String functionCode) {
        FunctionDefinePO functionDefinePo = this.functionDefineMapper.findByIdAndCode(functionId, functionCode);
        if (functionDefinePo == null) {
            if (null != functionId && StringUtils.isNotEmpty((CharSequence)functionCode)) {
                throw new FDSException(FDSResponseInfoEnum.FUNCTION_ID_AND_CODE_NOT_EXIST);
            }
            if (null != functionId) {
                throw new FDSException(FDSResponseInfoEnum.FUNCTION_NOT_EXIST);
            }
            if (StringUtils.isNotEmpty((CharSequence)functionCode)) {
                throw new FDSException(FDSResponseInfoEnum.FUNCTION_CODE_NOT_EXIST);
            }
        }
        FunctionDefineRspVO functionDefineRspVO = (FunctionDefineRspVO)this.mapper.map((Object)functionDefinePo, FunctionDefineRspVO.class);
        functionDefineRspVO.setNoticeConfigIds(this.splitToList(functionDefinePo.getNoticeConfigIds()));
        functionDefineRspVO.setUserId(functionDefinePo.getCreateUserId());
        if (functionDefinePo.getServiceId() != null) {
            ServiceDefinePO serviceDefinePo = this.serviceDefineMapper.selectByPrimaryKey(functionDefinePo.getServiceId());
            functionDefineRspVO.setServiceName(serviceDefinePo.getServiceName());
        }
        if (functionDefinePo.getTemplateId() != null) {
            TemplatePO templatePo = this.templateMapper.selectByPrimaryKey(functionDefinePo.getTemplateId());
            functionDefineRspVO.setTemplateName(templatePo.getTemplateName());
        }
        if (!CollectionUtils.isEmpty((Collection)functionDefineRspVO.getNoticeConfigIds())) {
            List descriptions = this.noticeCenterConfigMapper.queryDescriptionsByIds(functionDefineRspVO.getNoticeConfigIds());
            functionDefineRspVO.setDescriptions(StringUtils.join((Iterable)descriptions, (String)";"));
        }
        return functionDefineRspVO;
    }
}

