/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.console.service.notice.impl;

import com.github.pagehelper.PageInfo;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.filedownload.console.service.notice.NoticeCenterConfigService;
import com.ohaotian.filedownload.core.common.BaseResponse;
import com.ohaotian.filedownload.core.common.Consts;
import com.ohaotian.filedownload.core.common.PageQueryResponse;
import com.ohaotian.filedownload.core.dao.entity.NoticeCenterConfigPO;
import com.ohaotian.filedownload.core.dao.mapper.NoticeCenterConfigPOMapper;
import com.ohaotian.filedownload.core.model.notice.request.NoticeReqVO;
import com.ohaotian.filedownload.core.model.notice.response.NoticeRspVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dozer.Mapper;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NoticeCenterConfigServiceImpl
implements NoticeCenterConfigService {
    @Autowired
    private NoticeCenterConfigPOMapper noticeCenterConfigMapper;
    @Autowired
    private Mapper mapper;

    @Override
    public BaseResponse<PageQueryResponse> pageQueryList(NoticeReqVO noticeReqVO) {
        NoticeCenterConfigPO po = (NoticeCenterConfigPO)this.mapper.map((Object)noticeReqVO, NoticeCenterConfigPO.class);
        noticeReqVO.confirmAuthority(po);
        PageInfo pageInfo = PageMethod.startPage((int)noticeReqVO.getPageNo(), (int)noticeReqVO.getPageSize()).doSelectPageInfo(() -> this.noticeCenterConfigMapper.findBy(po));
        return PageQueryResponse.success((PageInfo)pageInfo);
    }

    @Override
    public List<NoticeRspVO> listAll() {
        NoticeCenterConfigPO po = new NoticeCenterConfigPO();
        po.setIsDelete(Consts.UNDELETED_FLAG);
        List poList = this.noticeCenterConfigMapper.findBy(po);
        ArrayList<NoticeRspVO> boList = new ArrayList<NoticeRspVO>();
        poList.forEach(poo -> boList.add((NoticeRspVO)this.mapper.map(poo, NoticeRspVO.class)));
        return boList;
    }

    @Override
    public NoticeRspVO detail(NoticeReqVO reqBO) {
        NoticeRspVO bo = new NoticeRspVO();
        NoticeCenterConfigPO ncConfigPo = new NoticeCenterConfigPO();
        reqBO.confirmAuthority(ncConfigPo);
        ncConfigPo.setNoticeConfigId(reqBO.getNoticeConfigId());
        NoticeCenterConfigPO existsPo = this.noticeCenterConfigMapper.selectBy(ncConfigPo);
        if (existsPo == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)existsPo, (Object)bo);
        return (NoticeRspVO)this.mapper.map((Object)existsPo, NoticeRspVO.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(NoticeReqVO reqBO) {
        NoticeCenterConfigPO po = (NoticeCenterConfigPO)this.mapper.map((Object)reqBO, NoticeCenterConfigPO.class);
        Date date = new Date();
        po.setCreateTime(date);
        po.setUpdateTime(date);
        po.setIsDelete(Consts.UNDELETED_FLAG);
        po.setSendPlatform(Consts.FDS_SEND_PLATFORM);
        po.setCreaterUserId(reqBO.getUserId());
        this.noticeCenterConfigMapper.insert(po);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(NoticeReqVO reqBO) {
        NoticeCenterConfigPO po = (NoticeCenterConfigPO)this.mapper.map((Object)reqBO, NoticeCenterConfigPO.class);
        po.setUpdateTime(new Date());
        po.setSendPlatform(Consts.FDS_SEND_PLATFORM);
        po.setUpdaterUserId(reqBO.getUserId());
        this.noticeCenterConfigMapper.updateByPrimaryKeySelective(po);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(NoticeReqVO reqBO) {
        NoticeCenterConfigPO po = new NoticeCenterConfigPO();
        po.setNoticeConfigId(reqBO.getNoticeConfigId());
        po.setIsDelete(Consts.DELETED_FLAG);
        po.setUpdateTime(new Date());
        po.setUpdaterUserId(reqBO.getUserId());
        this.noticeCenterConfigMapper.updateByPrimaryKeySelective(po);
    }
}

