/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.console.service.notice.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.filedownload.console.service.notice.NoticeCenterConfigService;
import com.ohaotian.filedownload.console.service.notice.SendNoticeCenterMsgService;
import com.ohaotian.filedownload.core.exception.FDSException;
import com.ohaotian.filedownload.core.exception.FDSResponseInfoEnum;
import com.ohaotian.filedownload.core.model.notice.request.NoticeReqVO;
import com.ohaotian.filedownload.core.model.notice.request.SncMsgReqVO;
import com.ohaotian.filedownload.core.model.notice.response.NoticeRspVO;
import com.ohaotian.filedownload.core.model.notice.response.SncMsgRspVO;
import com.ohaotian.filedownload.core.okhttp.OkHttpUtil;
import com.ohaotian.notify.notifyCenter.base.BaseBo;
import com.ohaotian.notify.notifyCenter.bo.MessageOnlyBO;
import java.util.Collections;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SendNoticeCenterMsgServiceImpl
implements SendNoticeCenterMsgService {
    private static final Logger log = LogManager.getLogger(SendNoticeCenterMsgServiceImpl.class);
    @Resource
    NoticeCenterConfigService noticeCenterConfigService;
    @Value(value="${com.ohaotian.notify.notifycenter.sendmsg}")
    private String sendMsgUrl;

    @Override
    public SncMsgRspVO sendOnlyMessage(SncMsgReqVO reqBO) throws FDSException {
        SncMsgRspVO rspBO = new SncMsgRspVO();
        Assert.notNull((Object)reqBO.getSendMsgUrl(), (String)"sendMsgUrl is null");
        MessageOnlyBO messageOnlyBO = new MessageOnlyBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)messageOnlyBO);
        log.info("send msg req param->{}", (Object)JSON.toJSONString((Object)messageOnlyBO));
        try {
            String result = OkHttpUtil.postWithJson((String)reqBO.getSendMsgUrl(), (String)JSON.toJSONString((Object)messageOnlyBO));
            log.info("send msg rsp param->{}", (Object)result);
            BaseBo baseBo = (BaseBo)JSON.parseObject((String)result, BaseBo.class);
            if (baseBo == null) {
                throw new FDSException(FDSResponseInfoEnum.NOTICE_CENTER_NULL_RETURN);
            }
            if (!"0".equals(baseBo.getCode())) {
                throw new FDSException("err in send msg ->" + baseBo.getMessage());
            }
            BeanUtils.copyProperties((Object)baseBo, (Object)rspBO);
        }
        catch (Exception e) {
            log.error("err in send msg ->{}", (Throwable)e);
            throw new FDSException("err in send msg->" + e);
        }
        return rspBO;
    }

    @Override
    public SncMsgRspVO sendMsgByConfigId(Long noticeConfigId, String json, String phoneNum, String mail) throws FDSException {
        log.info("\u53d1\u9001\u901a\u77e5\u4e2d\u5fc3\u6d88\u606f\u5165\u53c2\uff1anoticeConfigId->{},json->{},phoneNum->{},mail->{}", (Object)noticeConfigId, (Object)json, (Object)phoneNum, (Object)mail);
        if (noticeConfigId == null || StringUtils.isEmpty((String)json)) {
            throw new FDSException(FDSResponseInfoEnum.NOTICE_CENTER_PARAM_ERROR);
        }
        NoticeRspVO rsp = this.noticeCenterConfigService.detail(new NoticeReqVO(noticeConfigId));
        SncMsgReqVO msgReqVO = new SncMsgReqVO();
        msgReqVO.setSendMsgUrl(this.sendMsgUrl);
        msgReqVO.setTemplateParam(json);
        msgReqVO.setSendPlatform(rsp.getSendPlatform());
        msgReqVO.setTemplateId(rsp.getNoticeTemplateId());
        msgReqVO.setTemplateTypes(Collections.singletonList(rsp.getNoticeTemplateTypes()));
        if (!StringUtils.isEmpty((String)phoneNum)) {
            msgReqVO.setPhoneNum(phoneNum);
        }
        if (!StringUtils.isEmpty((String)mail)) {
            msgReqVO.setMail(mail);
        }
        return this.sendOnlyMessage(msgReqVO);
    }
}

