/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.console.service.template.impl;

import cn.hutool.core.util.StrUtil;
import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.google.common.collect.ImmutableMap;
import com.ohaotian.filedownload.console.service.template.TemplateService;
import com.ohaotian.filedownload.core.common.BaseResponse;
import com.ohaotian.filedownload.core.common.Consts;
import com.ohaotian.filedownload.core.common.PageQueryResponse;
import com.ohaotian.filedownload.core.dao.entity.FunctionDefinePO;
import com.ohaotian.filedownload.core.dao.entity.TemplatePO;
import com.ohaotian.filedownload.core.dao.mapper.FunctionDefinePOMapper;
import com.ohaotian.filedownload.core.dao.mapper.TemplatePOMapper;
import com.ohaotian.filedownload.core.enums.PluginFileTypeEnum;
import com.ohaotian.filedownload.core.enums.TemplateTypeEnum;
import com.ohaotian.filedownload.core.exception.FDSException;
import com.ohaotian.filedownload.core.exception.FDSResponseInfoEnum;
import com.ohaotian.filedownload.core.model.template.request.TemplateDefinitionReqVO;
import com.ohaotian.filedownload.core.model.template.request.TemplateQueryReqVO;
import com.ohaotian.filedownload.core.model.template.request.UploadTemplateReqVO;
import com.ohaotian.filedownload.core.model.template.response.TemplateRspVO;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsConfig;
import com.ohaotian.plugin.file.oss.OssConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.dozer.Mapper;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TemplateServiceImpl
implements TemplateService {
    private static final Logger log = LoggerFactory.getLogger(TemplateServiceImpl.class);
    @Autowired
    private TemplatePOMapper templateMapper;
    @Autowired
    private FunctionDefinePOMapper functionDefineMapper;
    @Autowired
    private Mapper mapper;
    @Value(value="${file.templateDirPath}")
    private String fileTemplateDirPath;
    @Autowired
    private FileClient fileClient;
    @Value(value="${plugin.file.type}")
    private String pluginFileType;
    @Value(value="${fastdfs.accessUrl:}")
    private String fastdfsAccessUrl;
    @Autowired
    private OssConfig ossConfig;
    @Autowired
    private FastdfsConfig fastdfsConfig;

    @Override
    public int saveTemplate(TemplateDefinitionReqVO templateDefinitionReqVO) {
        templateDefinitionReqVO.checkTemplateDefinition();
        TemplatePO templatePo = (TemplatePO)this.mapper.map((Object)templateDefinitionReqVO, TemplatePO.class);
        templateDefinitionReqVO.mappingFieldForAdd(templatePo);
        List records = this.templateMapper.findByPO(templatePo);
        if (records != null && records.size() > 0) {
            throw new FDSException(FDSResponseInfoEnum.NAME_EXISTS_EXCEPTION);
        }
        if (StrUtil.isNotEmpty((CharSequence)templateDefinitionReqVO.getOriginalFileTemplateName()) && !templateDefinitionReqVO.getOriginalFileTemplateName().endsWith(".xlsx")) {
            InputStream inputStream = this.fileClient.downLoadToInputStream(templateDefinitionReqVO.getOriginalFileTemplateName());
            try {
                templatePo.setFileTemplateContent(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new FDSException(FDSResponseInfoEnum.FILE_TEMPLATE_CANT_NULL);
            }
        }
        return this.templateMapper.insert(templatePo);
    }

    @Override
    public int updateTemplate(TemplateDefinitionReqVO templateDefinitionReqVO) {
        templateDefinitionReqVO.checkTemplateDefinition();
        TemplatePO templatePo = (TemplatePO)this.mapper.map((Object)templateDefinitionReqVO, TemplatePO.class);
        if (!templateDefinitionReqVO.getOriginalFileTemplateName().contains("/")) {
            templateDefinitionReqVO.setOriginalFileTemplateName(null);
        } else {
            InputStream inputStream = this.fileClient.downLoadToInputStream(templateDefinitionReqVO.getOriginalFileTemplateName());
            try {
                templatePo.setFileTemplateContent(IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new FDSException(FDSResponseInfoEnum.FILE_TEMPLATE_CANT_NULL);
            }
        }
        templateDefinitionReqVO.mappingFieldForUpdate(templatePo);
        int result = this.templateMapper.updateByPrimaryKeySelective(templatePo);
        if (result < 1) {
            return result;
        }
        FunctionDefinePO queryPo = new FunctionDefinePO();
        queryPo.setTemplateId(templateDefinitionReqVO.getFileTemplateId());
        List functionPos = this.functionDefineMapper.findByPO(queryPo);
        if (!CollectionUtils.isEmpty((Collection)functionPos)) {
            FunctionDefinePO updatePo = new FunctionDefinePO();
            for (FunctionDefinePO po : functionPos) {
                updatePo.setFunctionId(po.getFunctionId());
                updatePo.setBusinessCenterId(templateDefinitionReqVO.getBusinessCenterId());
                this.functionDefineMapper.updateByPrimaryKeySelective(updatePo);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ImmutableMap<String, String> uploadTemplate(UploadTemplateReqVO uploadTemplateReqVO) {
        log.info("## \u6587\u4ef6\u6a21\u677f\u4e0a\u4f20\u5f00\u59cb ...");
        MultipartFile file = uploadTemplateReqVO.getFile();
        String originalFileName = uploadTemplateReqVO.checkAndGetFileName();
        try (InputStream fis = file.getInputStream();){
            String path = this.fileClient.uploadFileByInputStream(Consts.FILE_TEMPLATE_PATH + "/" + uploadTemplateReqVO.getBusinessCenterId(), originalFileName, fis);
            ImmutableMap immutableMap = new ImmutableMap.Builder().put((Object)"originalFileTemplateName", (Object)path).build();
            return immutableMap;
        }
        catch (IOException e) {
            log.error("\u5f85\u4e0a\u4f20\u6587\u4ef6\u6a21\u677f\u4e0d\u5b58\u5728 {}", (Throwable)e);
            throw new FDSException(FDSResponseInfoEnum.UPLOAD_FILE_NOT_EXIST_ERROR);
        }
    }

    private void dealBackup(UploadTemplateReqVO uploadTemplateReqVO, InputStream fis, String path) {
        switch (PluginFileTypeEnum.codeOf((String)this.pluginFileType)) {
            case FASTDFS: {
                log.info("fastDFS\u4e0a\u4f20\u6587\u4ef6\u5730\u5740\uff1a {}", (Object)(this.fastdfsAccessUrl + ":" + this.fastdfsConfig.getHttpTrackerHttpPort() + "/" + path));
                log.info("##\u6587\u4ef6\u5b58\u50a8\u4ecb\u8d28\u4e3a\uff1afastDFS\uff0c\u5f00\u59cb\u5907\u4efd\u6a21\u677f\u6587\u4ef6");
                String parentDir = this.parentDir(uploadTemplateReqVO.getBusinessCenterId());
                StringBuilder fileNameBuilder = new StringBuilder(uploadTemplateReqVO.checkAndGetFileName());
                fileNameBuilder.insert(fileNameBuilder.lastIndexOf("."), DateTime.now().toString("yyyyMMddHHmmss"));
                String filePath = parentDir + File.separator + fileNameBuilder;
                try {
                    File backupFile = new File(filePath);
                    FileUtils.forceMkdirParent((File)backupFile);
                    FileUtils.copyToFile((InputStream)fis, (File)backupFile);
                    log.info("##\u6587\u4ef6\u6a21\u677f\u5907\u4efd\u5b8c\u6210\uff0cfilePath: {}", (Object)filePath);
                }
                catch (IOException e) {
                    log.error("##\u6587\u4ef6\u6a21\u677f\u5907\u4efd\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                    e.printStackTrace();
                }
                break;
            }
            case OSS: {
                log.info("oss\u4e0a\u4f20\u6587\u4ef6\u5730\u5740\uff1a {}", (Object)(this.ossConfig.getAccessUrl() + "/" + path));
                break;
            }
        }
    }

    @Override
    public BaseResponse deleteTemplate(TemplateDefinitionReqVO deleteTemplateDetailReqBO) {
        FunctionDefinePO functionDefinePo = new FunctionDefinePO();
        functionDefinePo.setTemplateId(deleteTemplateDetailReqBO.getFileTemplateId());
        if (!this.functionDefineMapper.findByPO(functionDefinePo).isEmpty() || this.functionDefineMapper.findByPO(functionDefinePo).size() >= 1) {
            BaseResponse baseResponse = new BaseResponse();
            baseResponse.setCode("1");
            baseResponse.setMessage("\u6709\u529f\u80fd\u5728\u4f7f\u7528\u8be5\u6587\u4ef6\u6a21\u677f\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
            return baseResponse;
        }
        TemplatePO templatePo = this.templateMapper.selectByPrimaryKeyWithAuth(deleteTemplateDetailReqBO.getFileTemplateId(), deleteTemplateDetailReqBO.confirmAuthority(), deleteTemplateDetailReqBO.getUserId());
        if (this.isComPlexTemplate(templatePo)) {
            this.deleteTemplateFile(templatePo);
        }
        this.templateMapper.deleteByPrimaryKey(deleteTemplateDetailReqBO.getFileTemplateId());
        return BaseResponse.success();
    }

    @Override
    public TemplateRspVO queryTemplate(TemplateQueryReqVO templateQuery) {
        TemplatePO templatePo = this.templateMapper.selectByPrimaryKeyWithAuth(templateQuery.getFileTemplateId(), templateQuery.confirmAuthority(), templateQuery.getUserId());
        templatePo.setFileTemplateName(this.ossConfig.getAccessUrl() + "/" + templatePo.getFileTemplateName());
        if (PluginFileTypeEnum.FASTDFS.equals((Object)this.pluginFileType)) {
            templatePo.setFileTemplateName(this.fastdfsAccessUrl + ":" + this.fastdfsConfig.getHttpTrackerHttpPort() + "/" + templatePo.getFileTemplateName());
        }
        return this.convertToTemplateVO(templatePo);
    }

    @Override
    public BaseResponse<PageQueryResponse> queryTemplateList(TemplateQueryReqVO templateQueryReqVO) {
        templateQueryReqVO.confirmAuthority();
        Page page = PageMethod.startPage((int)templateQueryReqVO.getPageNo(), (int)templateQueryReqVO.getPageSize());
        List templatePoList = this.templateMapper.findBy(templateQueryReqVO);
        if (templatePoList == null) {
            templatePoList = Collections.emptyList();
        }
        List templateRspVOList = templatePoList.stream().map(this::convertToTemplateVO).collect(Collectors.toList());
        return PageQueryResponse.success((Page)page, templateRspVOList);
    }

    @Override
    public List<TemplateRspVO> queryTemplateListSelected(TemplateQueryReqVO templateQuery) {
        List templateList = this.templateMapper.queryFileTemplateSelectList(templateQuery.getUserId(), templateQuery.confirmAuthority());
        return templateList.stream().map(this::buildTemplateVO).collect(Collectors.toList());
    }

    @Override
    public TemplatePO findById(Long templateId) {
        return this.templateMapper.selectByPrimaryKey(templateId);
    }

    @Override
    public BaseResponse backup() {
        TemplateQueryReqVO reqVO = new TemplateQueryReqVO();
        reqVO.setFileTemplateType(Integer.valueOf(2));
        List templateList = this.templateMapper.findBy(reqVO);
        ArrayList<TemplatePO> updatePos = new ArrayList<TemplatePO>();
        for (TemplatePO item2 : templateList) {
            try {
                InputStream is = this.fileClient.downLoadToInputStream(item2.getFileTemplateName());
                item2.setFileTemplateContent(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                log.error("\u4e0b\u8f7d\u6a21\u677f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                continue;
            }
            TemplatePO updatePo = new TemplatePO();
            updatePo.setTemplateId(item2.getTemplateId());
            updatePo.setFileTemplateContent(item2.getFileTemplateContent());
            updatePos.add(updatePo);
        }
        updatePos.forEach(item -> this.templateMapper.updateByPrimaryKeySelective(item));
        return BaseResponse.success();
    }

    private String parentDir(String businessCenterId) {
        return this.fileTemplateDirPath + File.separator + businessCenterId;
    }

    private String checkFileName(String originalFileName, String businessCenterId) {
        int count = this.templateMapper.findByFileTemplateNameAndBusinessCenterId(originalFileName, businessCenterId);
        if (count > 0) {
            log.warn("## \u8be5\u4e1a\u52a1\u4e2d\u5fc3\u4e0b\u5df2\u6709\u540c\u540d\u7684\u6a21\u677f\u6587\u4ef6");
            throw new FDSException(FDSResponseInfoEnum.FILE_TEMPLATE_ALREADY_EXIST);
        }
        return originalFileName;
    }

    private TemplateRspVO convertToTemplateVO(TemplatePO templatePo) {
        TemplateRspVO templateRspVO = new TemplateRspVO();
        BeanUtils.copyProperties((Object)templatePo, (Object)templateRspVO);
        templateRspVO.mappingField(templatePo);
        return templateRspVO;
    }

    private TemplateRspVO buildTemplateVO(TemplatePO p) {
        return TemplateRspVO.builder().fileTemplateId(p.getTemplateId()).fileTemplateName(p.getTemplateName()).businessCenterId(p.getBusinessCenterId()).build();
    }

    private boolean isComPlexTemplate(TemplatePO templatePo) {
        return Objects.equals(TemplateTypeEnum.COMPLEX, TemplateTypeEnum.codeOf((int)templatePo.getTemplateType()));
    }

    private void deleteTemplateFile(TemplatePO templatePo) {
        String filePath = this.parentDir(templatePo.getBusinessCenterId()) + File.separator + templatePo.getFileTemplateName();
        File file = new File(filePath);
        if (file.exists()) {
            try {
                FileUtils.forceDelete((File)file);
            }
            catch (IOException e) {
                log.error("## \u5220\u9664\u6a21\u677f\u6587\u4ef6\u5931\u8d25: {}", (Object)filePath);
            }
        }
    }
}

