/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.filedownload.console.service.user.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.filedownload.console.service.user.UserService;
import com.ohaotian.filedownload.core.enums.AuthIdentityEnum;
import com.ohaotian.filedownload.core.exception.FDSException;
import com.ohaotian.filedownload.core.okhttp.OkHttpUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements UserService {
    private static final Logger log = LogManager.getLogger(UserServiceImpl.class);
    @Value(value="${com.ohaotian.authority.domain}")
    private String authorityDomain;
    @Value(value="${com.ohaotian.authority.appcode}")
    private String appCode;
    @Value(value="${com.ohaotian.authority.super}")
    private String superManager;
    @Value(value="${com.ohaotian.authority.normal}")
    private String normalManager;
    private final String USERID = "userId";
    private final String AUTHTOKEN = "auth-token";

    @Override
    public Map<String, Object> getUserInfo(String userId) throws Exception {
        String authToken = this.getAuthToken(userId);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", userId);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("auth-token", authToken);
        String result = OkHttpUtil.get((String)(this.authorityDomain + "/rest/portal/authForApp/query/userInfo"), params, header);
        return (Map)JSON.parseObject((String)result, Map.class);
    }

    @Override
    public Map<String, Object> getMenuAuth(String userId) throws Exception {
        String authToken = this.getAuthToken(userId);
        HashMap<String, String> meanParams = new HashMap<String, String>();
        meanParams.put("userId", userId);
        meanParams.put("appCode", this.appCode);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("auth-token", authToken);
        String result = OkHttpUtil.get((String)(this.authorityDomain + "/rest/portal/authForApp/query/loadUserMenus"), meanParams, header);
        return (Map)JSON.parseObject((String)result, Map.class);
    }

    @Override
    public AuthIdentityEnum getAuthIdentity(String userId) throws Exception {
        String authToken = this.getAuthToken(userId);
        HashMap<String, String> meanParams = new HashMap<String, String>();
        meanParams.put("userId", userId);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("auth-token", authToken);
        String result = OkHttpUtil.get((String)(this.authorityDomain + "/rest/portal/user/selectUserRoles"), meanParams, header);
        return this.getAuthority(result);
    }

    private String getAuthToken(String userId) throws IOException {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("userId", userId);
        String result = OkHttpUtil.get((String)(this.authorityDomain + "/rest/portal/user/selectUserRoles"), paramsMap);
        String authToken = JSON.parseObject((String)result).getJSONObject("data").getString("token");
        log.debug("token\uff1a" + authToken);
        return authToken;
    }

    private AuthIdentityEnum getAuthority(String result) {
        try {
            JSONArray userRoles = JSON.parseObject((String)result).getJSONObject("data").getJSONArray("userRoles");
            for (Object o : userRoles) {
                JSONObject role = (JSONObject)o;
                String authIdentity = role.getString("authIdentity");
                if (authIdentity.equals(this.superManager)) {
                    return AuthIdentityEnum.SUPER_MANAGER;
                }
                if (!authIdentity.equals(this.normalManager)) continue;
                return AuthIdentityEnum.NORMAL_MANAGER;
            }
        }
        catch (FDSException exception) {
            log.warn("\u672a\u5339\u914d\u5230\u89d2\u8272\u6743\u9650\uff0c\u9ed8\u8ba4\u4e3a\u3010\u65e0\u6743\u9650\u7528\u6237\u3011");
        }
        return AuthIdentityEnum.NO_AUTH;
    }
}

