/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.ohaotian.abilitycommon.config.zookeeper.NodeInfoConfig;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.SelfDefHeader;
import com.ohaotian.abilitycommon.model.bo.system.TlogReqHeader;
import com.ohaotian.abilitycommon.plugin.PluginC;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilitycommon.util.ReflectBeanValueUtil;
import com.ohaotian.plugin.mapper.MultiHpartyCheckTokenMapper;
import com.ohaotian.plugin.model.po.MultiHpartyCheckTokenPO;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="multiHpartyCheckService")
public class MultiHpartyCheckService
implements PluginC {
    private static final Logger log = LogManager.getLogger(MultiHpartyCheckService.class);
    @Resource
    MultiHpartyCheckTokenMapper multiHpartyCheckTokenMapper;
    @Value(value="${multi.default.orgid:1000}")
    private String multiDefaultOrgId;
    @Value(value="${multi.default.param:orgId}")
    private String multiDefaultParam;
    @Resource
    private StringRedisTemplate strRedisTemplate;
    @Resource
    private NodeInfoConfig nodeInfoConfig;

    public void doService(MsgContext msgContext) throws AbilityException {
        try {
            log.debug("MultiHpartyCheckService -- > {}", (Object)"\u5f00\u59cb\u8fd0\u884c");
            List abilityPluginBOList = msgContext.getEsbAbility().getAbilityPluginBOList().stream().filter(bo -> "multiTokenHPC".equalsIgnoreCase(bo.getPluginType())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(abilityPluginBOList)) {
                log.debug("multiTokenHPC-\u672a\u8ba2\u8d2d");
                return;
            }
            TlogReqHeader tlogReqHeader = msgContext.getTlogReqHeader();
            String value = ReflectBeanValueUtil.getValue((Object)tlogReqHeader.getReqObj(msgContext), (String)"hsn") + "";
            log.info("multiTokenHPC : \u6267\u884c\u5206\u533a\u63d2\u4ef6 --> {}", (Object)value);
            String pluginId = abilityPluginBOList.stream().map(a -> String.valueOf(a.getPluginId())).findFirst().get();
            MultiHpartyCheckTokenPO queryCondition = new MultiHpartyCheckTokenPO();
            queryCondition.setPluginId(StringUtils.isNotBlank((CharSequence)pluginId) ? Long.parseLong(pluginId) : 0L);
            SelfDefHeader selfDefHeader = msgContext.getSelfDefHeader();
            HashMap reqMap = Maps.newHashMap();
            Map req = this.json2Map(new String(tlogReqHeader.getReqData(), "UTF-8"));
            Object o = req.get(this.multiDefaultParam);
            if (o != null && StringUtils.isNotEmpty((CharSequence)String.valueOf(o))) {
                String orgId = String.valueOf(o);
                String key = "multiTokenHPC-" + this.nodeInfoConfig.getClusterId() + "-" + pluginId + "-" + orgId;
                String s = (String)this.strRedisTemplate.opsForValue().get((Object)key);
                if (Objects.isNull(s)) {
                    orgId = this.multiDefaultOrgId;
                }
                queryCondition.setOrgId(orgId);
            } else {
                queryCondition.setOrgId(this.multiDefaultOrgId);
            }
            String key = "multiTokenHPC-" + this.nodeInfoConfig.getClusterId() + "-" + queryCondition.getPluginId() + "-" + queryCondition.getOrgId();
            String s = (String)this.strRedisTemplate.opsForValue().get((Object)key);
            if (Objects.isNull(s)) {
                throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":multiTokenHPCService >>> \u6b64\u5206\u533aorgid:1000 \u9ed8\u8ba4\u8d26\u6237\u672a\u914d\u7f6e"}));
            }
            MultiHpartyCheckTokenPO multiHpartyCheckTokenPO = (MultiHpartyCheckTokenPO)GsonUtil.fromJson((String)s, MultiHpartyCheckTokenPO.class);
            req.forEach((k, y) -> reqMap.put(k, y));
            reqMap.put("token", multiHpartyCheckTokenPO.getAccessToken());
            reqMap.put("appkey", multiHpartyCheckTokenPO.getClientId());
            switch (multiHpartyCheckTokenPO.getCallProtocol()) {
                case "0": {
                    tlogReqHeader.setReqData(GsonUtil.toJson((Object)reqMap).getBytes("UTF-8"));
                    break;
                }
                case "1": {
                    tlogReqHeader.setReqData(this.map2form(reqMap).getBytes("UTF-8"));
                    selfDefHeader.getSelfDefMap().put("Content-Type", "application/x-www-form-urlencoded");
                    break;
                }
                default: {
                    tlogReqHeader.setReqData(GsonUtil.toJson((Object)reqMap).getBytes("UTF-8"));
                }
            }
            log.debug("\u8c03\u7528\u843d\u5730\u62a5\u6587\u4e3a:" + new String(tlogReqHeader.getReqData(), "UTF-8"));
            msgContext.getEsbAbility().setIsAddToken(Boolean.TRUE);
            msgContext.setTlogReqHeader(tlogReqHeader);
        }
        catch (AbilityException e) {
            log.error(e.codeMsg.getRspDesc());
            throw e;
        }
        catch (Exception e) {
            log.error("multiTokenHPC\u63d2\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":multiTokenHPCService >>> multiTokenHPC\u63d2\u4ef6\u5f02\u5e38:"}) + e.getMessage());
        }
    }

    private String map2form(Map map) {
        StringBuffer s = new StringBuffer(16);
        map.forEach((k, v) -> {
            if (v instanceof Map) {
                s.append(k).append("=").append(JSONObject.fromObject((Object)v)).append("&");
            } else if (v instanceof List) {
                s.append(k).append("=").append(JSONArray.fromObject((Object)v)).append("&");
            } else {
                s.append(k).append("=").append(v).append("&");
            }
        });
        return s.toString().substring(0, s.length() - 1);
    }

    private Map json2Map(String json) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Map map = (Map)objectMapper.readValue(json, Map.class);
        return map;
    }

    private void insertJDToken() {
        MultiHpartyCheckTokenPO insetTokenPO = new MultiHpartyCheckTokenPO();
        insetTokenPO.setAccessToken("2");
        insetTokenPO.setPluginId(5L);
        insetTokenPO.setClientId("1");
        insetTokenPO.setRegionCode("yaoayo1");
        insetTokenPO.setUserName("root");
        long i = this.multiHpartyCheckTokenMapper.insertSelective(insetTokenPO);
    }

    public MultiHpartyCheckTokenMapper getMultiHpartyCheckTokenMapper() {
        return this.multiHpartyCheckTokenMapper;
    }

    public String getMultiDefaultOrgId() {
        return this.multiDefaultOrgId;
    }

    public String getMultiDefaultParam() {
        return this.multiDefaultParam;
    }

    public StringRedisTemplate getStrRedisTemplate() {
        return this.strRedisTemplate;
    }

    public NodeInfoConfig getNodeInfoConfig() {
        return this.nodeInfoConfig;
    }

    public void setMultiHpartyCheckTokenMapper(MultiHpartyCheckTokenMapper multiHpartyCheckTokenMapper) {
        this.multiHpartyCheckTokenMapper = multiHpartyCheckTokenMapper;
    }

    public void setMultiDefaultOrgId(String multiDefaultOrgId) {
        this.multiDefaultOrgId = multiDefaultOrgId;
    }

    public void setMultiDefaultParam(String multiDefaultParam) {
        this.multiDefaultParam = multiDefaultParam;
    }

    public void setStrRedisTemplate(StringRedisTemplate strRedisTemplate) {
        this.strRedisTemplate = strRedisTemplate;
    }

    public void setNodeInfoConfig(NodeInfoConfig nodeInfoConfig) {
        this.nodeInfoConfig = nodeInfoConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiHpartyCheckService)) {
            return false;
        }
        MultiHpartyCheckService other = (MultiHpartyCheckService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MultiHpartyCheckTokenMapper this$multiHpartyCheckTokenMapper = this.getMultiHpartyCheckTokenMapper();
        MultiHpartyCheckTokenMapper other$multiHpartyCheckTokenMapper = other.getMultiHpartyCheckTokenMapper();
        if (this$multiHpartyCheckTokenMapper == null ? other$multiHpartyCheckTokenMapper != null : !this$multiHpartyCheckTokenMapper.equals(other$multiHpartyCheckTokenMapper)) {
            return false;
        }
        String this$multiDefaultOrgId = this.getMultiDefaultOrgId();
        String other$multiDefaultOrgId = other.getMultiDefaultOrgId();
        if (this$multiDefaultOrgId == null ? other$multiDefaultOrgId != null : !this$multiDefaultOrgId.equals(other$multiDefaultOrgId)) {
            return false;
        }
        String this$multiDefaultParam = this.getMultiDefaultParam();
        String other$multiDefaultParam = other.getMultiDefaultParam();
        if (this$multiDefaultParam == null ? other$multiDefaultParam != null : !this$multiDefaultParam.equals(other$multiDefaultParam)) {
            return false;
        }
        StringRedisTemplate this$strRedisTemplate = this.getStrRedisTemplate();
        StringRedisTemplate other$strRedisTemplate = other.getStrRedisTemplate();
        if (this$strRedisTemplate == null ? other$strRedisTemplate != null : !this$strRedisTemplate.equals(other$strRedisTemplate)) {
            return false;
        }
        NodeInfoConfig this$nodeInfoConfig = this.getNodeInfoConfig();
        NodeInfoConfig other$nodeInfoConfig = other.getNodeInfoConfig();
        return !(this$nodeInfoConfig == null ? other$nodeInfoConfig != null : !this$nodeInfoConfig.equals(other$nodeInfoConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MultiHpartyCheckService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MultiHpartyCheckTokenMapper $multiHpartyCheckTokenMapper = this.getMultiHpartyCheckTokenMapper();
        result = result * 59 + ($multiHpartyCheckTokenMapper == null ? 43 : $multiHpartyCheckTokenMapper.hashCode());
        String $multiDefaultOrgId = this.getMultiDefaultOrgId();
        result = result * 59 + ($multiDefaultOrgId == null ? 43 : $multiDefaultOrgId.hashCode());
        String $multiDefaultParam = this.getMultiDefaultParam();
        result = result * 59 + ($multiDefaultParam == null ? 43 : $multiDefaultParam.hashCode());
        StringRedisTemplate $strRedisTemplate = this.getStrRedisTemplate();
        result = result * 59 + ($strRedisTemplate == null ? 43 : $strRedisTemplate.hashCode());
        NodeInfoConfig $nodeInfoConfig = this.getNodeInfoConfig();
        result = result * 59 + ($nodeInfoConfig == null ? 43 : $nodeInfoConfig.hashCode());
        return result;
    }

    public String toString() {
        return "MultiHpartyCheckService(multiHpartyCheckTokenMapper=" + this.getMultiHpartyCheckTokenMapper() + ", multiDefaultOrgId=" + this.getMultiDefaultOrgId() + ", multiDefaultParam=" + this.getMultiDefaultParam() + ", strRedisTemplate=" + this.getStrRedisTemplate() + ", nodeInfoConfig=" + this.getNodeInfoConfig() + ")";
    }
}

