package com.ohaotian.plugin.actuator.web;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

@RestController
public class BeanController {

    private static Logger logger = LoggerFactory.getLogger(BeanController.class);

    @RequestMapping(value = "/beans", method = RequestMethod.GET)
    public String[] getBeans(HttpServletRequest request) {
        WebApplicationContext webApplicationContext = WebApplicationContextUtils.getWebApplicationContext(request.getSession().getServletContext());
        return webApplicationContext.getBeanDefinitionNames();
    }

    @RequestMapping(value = "/urls", method = RequestMethod.GET)
    public Map getUrls(HttpServletRequest request) {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext(request.getSession().getServletContext());
        RequestMappingHandlerMapping mappingHandlerMapping = context.getBean(RequestMappingHandlerMapping.class);
        Map<RequestMappingInfo, HandlerMethod> map = mappingHandlerMapping.getHandlerMethods();
        for (RequestMappingInfo info : map.keySet()) {
            logger.info(info.getPatternsCondition().toString() + "," + map.get(info).getBean().toString());
        }
        return map;
    }
}