/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.base.filter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class EmojiFilteringHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final byte[] body;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmojiFilteringHttpServletRequestWrapper(HttpServletRequest request, String pattern) throws IOException {
        super(request);
        String bodyStr = "";
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = null;){
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
                char[] charBuffer = new char[128];
                int bytesRead = -1;
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                }
            }
        }
        bodyStr = stringBuilder.toString().replaceAll(pattern, "");
        this.body = bodyStr.getBytes(StandardCharsets.UTF_8);
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public boolean isFinished() {
                return byteArrayInputStream.available() == 0;
            }

            public boolean isReady() {
                return true;
            }

            public int read() throws IOException {
                return byteArrayInputStream.read();
            }

            public void setReadListener(ReadListener readListener) {
                throw new UnsupportedOperationException("This implementation does not support ReadListener.");
            }
        };
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }
}

