/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.base.filter;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.base.filter.XssAndSqlHttpServletRequestWrapper;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class XssAndSqlFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(XssAndSqlFilter.class);
    @Value(value="${security.xss.key:and|exec|insert|select|delete|update|count|%|chr|mid|master|truncate|char|declare|or|like|where|union|order|by|table|from|grant|use|group_concat|column_name|information_schema.columns|table_schema|}")
    private String securityXssKey;
    private boolean enable;
    private String regx;

    public void init(FilterConfig config) throws ServletException {
        if (this.securityXssKey.lastIndexOf("|") == this.securityXssKey.length() - 1) {
            this.securityXssKey = this.securityXssKey.substring(0, this.securityXssKey.length() - 1);
        }
        this.regx = "\\b(" + this.securityXssKey + ")\\b";
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.enable) {
            String contentType = request.getContentType();
            if (contentType != null && contentType.startsWith("multipart/form-data")) {
                chain.doFilter(request, response);
            } else {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                XssAndSqlHttpServletRequestWrapper xssAndSqlHttpServletRequestWrapper = new XssAndSqlHttpServletRequestWrapper(httpRequest);
                request.setCharacterEncoding("utf-8");
                response.setContentType("text/html;charset=utf-8");
                String body = new String(xssAndSqlHttpServletRequestWrapper.body, request.getCharacterEncoding());
                log.info("CrosXssFilter..........doFilter url:{}, body:{}", (Object)xssAndSqlHttpServletRequestWrapper.getRequestURI(), (Object)body);
                if (null != body && Pattern.compile(this.regx).matcher(body).find()) {
                    log.error("[" + httpRequest.getRequestURI() + "]\uff0c\u8bf7\u6c42\u53c2\u6570\u4e2d\u5305\u542b\u4e0d\u5141\u8bb8sql\u7684\u5173\u952e\u8bcd");
                    throw new ZTBusinessException("[" + httpRequest.getRequestURI() + "]\uff0c\u8bf7\u6c42\u53c2\u6570\u4e2d\u5305\u542b\u4e0d\u5141\u8bb8sql\u7684\u5173\u952e\u8bcd");
                }
                chain.doFilter((ServletRequest)xssAndSqlHttpServletRequestWrapper, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }
}

