package com.ohaotian.plugin.common.util;

import java.util.Date;

import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

/** <br>
 * 标题: <br>
 * 描述: <br>
 * 公司: www.tydic.com<br>
 * 
 * @autho liuce
 * @time 2016年11月18日 上午12:44:54 */
public class EsUtil {

	static final DateTimeFormatter formatter = ISODateTimeFormat.dateTime().withZone(DateTimeZone.forOffsetHours(+8));

	/**
	 * 解析 es 读取的时间字符串   到  java.util.Date
	 */
	public static Date parseDateTime(String esDateTime) {
		return new Date(formatter.parseDateTime(esDateTime).getMillis());
	}
	/**
	 * 处理外围输入正则表达式 到  es所支撑的正则表达式
	 */
	public static String processRegexp(String regexp){
		if(regexp.startsWith("^")){
			regexp = regexp.substring(1, regexp.length());
		}
		if(regexp.endsWith("$")){
			regexp = regexp.substring(0, regexp.length()-1);
		}
		regexp = regexp.replaceAll("\\\\d", "[0-9]");
		regexp = regexp.replaceAll("\\\\w", "[0-9]");
		return regexp;
	}
	
	public static void main(String[] args) {
		System.out.println(processRegexp("^130[0-9]{4}(4\\d\\d\\d|\\d4\\d\\d|\\d\\d4\\d|\\d\\d\\d4)$"));
	}
}
