package com.ohaotian.plugin.common.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;

/**
 * <p>标题: </p>
 * <p>描述: </p>
 * <p>公司: www.chinaunicom.com</p>
 * @autho zhangxu
 * @time 2016年5月24日 下午9:30:38
*/
public class DateUtils {

	public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";

	public static final String YYYYMMDD = "yyyyMMdd";

	public static final String YYYYMMDDHHMMSS2 = "yyyy/MM/dd/HH/mm/ss";

	public static final String YYYYMMDD2 = "yyyy-MM-dd";
	/**
	 *
	 * <p>方法名称：</p>
	 * <p>方法说明：</p>
	 * @param strDate
	 * @param pattern 传入字符串格式
	 * @return
	 * @autho administrator
	 * @time 2016年6月16日 下午5:12:33
	 */
	public static Date strToDate(String strDate,String pattern) {
		if(StringUtils.isBlank(strDate)){
			return null;
		}
		SimpleDateFormat formatter = new SimpleDateFormat(pattern);
		ParsePosition pos = new ParsePosition(0);
		Date date = formatter.parse(strDate, pos);
		return date;
	}

	/**
	 * <p>方法名称：将长时间格式字符串转换为时间 yyyy-MM-dd HH:mm:ss </p>
	 * <p>方法说明：</p>
	 * @param strDate
	 * @return
	 * @autho zhangxu
	 * @time 2016年5月24日 下午9:34:57
	 */
	public static Date strToDateLong(String strDate) {
		if(StringUtils.isBlank(strDate)){
			return null;
		}
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		ParsePosition pos = new ParsePosition(0);
		Date strtodate = formatter.parse(strDate, pos);
		return strtodate;
	}


	/**
	 * <p>方法名称：将长时间格式字符串转换为时间 yyyy-MM-dd HH:mm:ss </p>
	 * <p>方法说明：</p>
	 * @param strDate
	 * @return
	 * @autho zhangxu
	 * @time 2016年5月24日 下午9:34:57
	 */
	public static Date strToDateLong(String strDate,String pattern) {
		if(StringUtils.isBlank(strDate)){
			return null;
		}
		SimpleDateFormat formatter = new SimpleDateFormat(pattern);
		ParsePosition pos = new ParsePosition(0);
		Date strtodate = formatter.parse(strDate, pos);
		return strtodate;
	}

	/**
	 * <p>方法名称：将时间格式为strToDateyyyyMMddHHmmss转化为日期格式</p>
	 * <p>方法说明：</p>
	 * @param strDate
	 * @return
	 * @autho wangming
	 * @time 2016年6月23日 下午2:10:44
	 */
	public static Date strToDateyyyyMMddHHmmss(String strDate) {
		if(StringUtils.isBlank(strDate)){
			return null;
		}
		SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
		ParsePosition pos = new ParsePosition(0);
		Date strtodate = formatter.parse(strDate, pos);
		return strtodate;
	}


	/**
	 * <p>方法名称：将时间转化为(yyyyMMdd)的字符串</p>
	 * <p>方法说明：</p>
	 * @param strDate
	 * @return
	 * @autho zsh
	 * @time 2016年6月23日 下午2:10:44
	 */
	public static String DateToStryyyyMMdd(Date date) {
		if(date == null){
			return null;
		}
		SimpleDateFormat formatter = new SimpleDateFormat(DateUtils.YYYYMMDD);
		String dateString = formatter.format(date);
		return dateString;
	}


	public static void main(String[] args) {
		System.out.println(dateToStr(getDateByMonth(strToDateLong("201701", "yyyyMM"),-3),"yyyyMM"));
	}
	/**
	 * <p>方法名称：date--->String </p>
	 * <p>方法说明：
	 * 		将长时间格式时间转换为字符串 yyyy-MM-dd HH:mm:ss
	 * </p>
	 * @param date
	 * @return
	 * @autho zhangxu
	 * @time 2016年5月24日 下午9:35:22
	 */
	public static String dateToStrLong(Date date) {
		if(date == null){
			return "";
		}
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String dateString = formatter.format(date);
		return dateString;
	}

	/**
	 * <p>方法名称：将日期转化为格式yyyyMMdd的字符串</p>
	 * <p>方法说明：</p>
	 * @param date
	 * @return
	 * @autho wangming
	 * @time 2016年6月23日 下午4:48:28
	 */
	public static String dateToStrYYYYMMdd(Date date) {
		if(date == null){
			return "";
		}
		SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
		String dateString = formatter.format(date);
		return dateString;
	}

	/**
	 * <p>方法名称：date-->String </p>
	 * <p>方法说明：
	 * 		将短时间格式时间转换为字符串 yyyy-MM-dd
	 * </p>
	 * @param date
	 * @return
	 * @autho zhangxu
	 * @time 2016年5月24日 下午9:35:40
	 */
	public static String dateToStr(Date date) {
		if(date == null){
			return "";
		}
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
		String dateString = formatter.format(date);
		return dateString;
	}

	/**
	 * <p>方法名称：String--->Date </p>
	 * <p>方法说明：
	 * 		将短时间格式字符串转换为时间 yyyy-MM-dd
	 * </p>
	 * @param strDate
	 * @return
	 * @autho zhangxu
	 * @time 2016年5月24日 下午9:35:56
	 */
	public static Date strToDate(String strDate) {
		if(StringUtils.isBlank(strDate)){
			return null;
		}
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
		ParsePosition pos = new ParsePosition(0);
		Date strtodate = formatter.parse(strDate, pos);
		return strtodate;
	}

	/**
	 * <p>方法名称：获取当前时间 </p>
	 * <p>方法说明：
	 * 		获取时间   小时:分;秒 HH:mm:ss
	 * </p>
	 * @return
	 * @autho zhangxu
	 * @time 2016年5月24日 下午9:36:15
	 */
	public static String getTimeShort() {
		SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
		Date currentTime = new Date();
		String dateString = formatter.format(currentTime);
		return dateString;
	}

	/**
	 *
	 * <p>方法名称：</p>
	 * <p>方法说明：</p>
	 * @param date
	 * @param pattern 转化后的字符串格式
	 * @return
	 * @autho administrator
	 * @time 2016年6月16日 下午5:16:00
	 */
	public static String dateToStr(Date date,String pattern) {
		if(date == null){
			return "";
		}
		SimpleDateFormat df = new SimpleDateFormat(pattern);// 设置日期格式
		return df.format(date);// new Date()为获取当前系统时间
	}


	/**
	 *
	 * <p>方法名称：时间显示转化</p>
	 * <p>方法说明：</p>
	 * @param str
	 * @param newPattern
	 * @param oldPattern
	 * @return
	 * @autho wangting
	 * @time 2016年6月24日 下午3:04:11
	 */
	public static String strTostr(String str,String newPattern,String oldPattern){
		Date date = strToDate(str,oldPattern);
		String newStr = dateToStr(date,newPattern);
		return newStr;
	}

	/**
	 *
	 * <p>方法名称：获取日期</p>
	 * <p>方法说明：在特定日期的基础上增加或者减少天数</p>
	 * @param date
	 * @param days
	 * @return
	 * @autho wangting
	 * @time 2016年8月13日 上午11:29:58
	 */
	public static Date getDate(Date date,Integer days){
		Calendar calendar =Calendar.getInstance();
		calendar.setTime(date);
		if (days != null) {
			calendar.add(Calendar.DAY_OF_MONTH, days);
		}
		return calendar.getTime();
	}

	/**
	 *
	 * <p>方法名称：获取日期</p>
	 * <p>方法说明：在特定日期的基础上增加或者减少月份</p>
	 * @param date
	 * @param days
	 * @return
	 * @autho zsh
	 * @time 2017年8月29日 上午11:29:58
	 */
	public static Date getDateByMonth(Date date,Integer month){
		Calendar calendar =Calendar.getInstance();
		calendar.setTime(date);
		if (month != null) {
			calendar.add(Calendar.MONTH, month);
		}
		return calendar.getTime();
	}


	/**
	 *
	 * <p>方法名称：判断一个字符串是不是一个正确的日期格式</p>
	 * @param dateStr 时间字符串
	 * @param datePattern 时间格式
	 * @return 格式正确返回true,反之返回false
	 * @autho
	 * @time 2016年8月13日 上午11:29:58
	 */
	public static boolean isValidDate(String dateStr,String datePattern) {
		if(StringUtils.isBlank(dateStr) || StringUtils.isBlank(datePattern)){
			return false;
		}
		boolean convertSuccess=true;
		SimpleDateFormat format = new SimpleDateFormat(datePattern);
		try {
			format.setLenient(false);
			format.parse(dateStr);
		} catch (ParseException e) {
			convertSuccess=false;
		}
		return convertSuccess;
	}

	public static String getCurrentMaxDate(String date) {
		if(StringUtils.isBlank(date)){
			return "";
		}
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
		ParsePosition pos = new ParsePosition(0);
		Date strtodate = formatter.parse(date, pos);
		String dateString = formatter.format(strtodate) + " 23:59:59";
		return dateString;
	}

	public static String getCurrentMinDate(String date) {
		if(StringUtils.isBlank(date)){
			return "";
		}
		SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
		ParsePosition pos = new ParsePosition(0);
		Date strtodate = formatter.parse(date, pos);
		String dateString = formatter.format(strtodate) + " 00:00:00";
		return dateString;
	}

	/**
	 * 比较时间大小
	 * date1  > date2  return true
	 * @param date1
	 * @param date2
	 * @return
	 */
	public static boolean IsCompareDate(String date1,String date2,String format) {

		if(StringUtils.isNotBlank(date1) && StringUtils.isNotBlank(date2)){
			SimpleDateFormat formatter = new SimpleDateFormat(format);
			ParsePosition pos = new ParsePosition(0);
			ParsePosition pos2 = new ParsePosition(0);
			Date date1Time = formatter.parse(date1, pos);
			Date date2Time = formatter.parse(date2, pos2);

            return date1Time.getTime() > date2Time.getTime();
		}else{
            return StringUtils.isNotBlank(date1);
		}
	}





}
