/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.es.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.transport.client.PreBuiltTransportClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class PluginEsConfig {
    private final Logger logger = LogManager.getLogger(PluginEsConfig.class);
    @Value(value="${es.cluster.name:}")
    private String clusterName;
    @Value(value="${es.cluster.nodes:}")
    private String clusterNodes;

    @Bean(destroyMethod="close")
    public TransportClient pluginEsClient() {
        if (StringUtils.isEmpty((Object)this.clusterName) || StringUtils.isEmpty((Object)this.clusterNodes)) {
            this.logger.error("plugin-es: config error.");
            return null;
        }
        Settings settings = Settings.builder().put("cluster.name", this.clusterName).build();
        PreBuiltTransportClient client = new PreBuiltTransportClient(settings, new Class[0]);
        List<AddressPairs> addressPairs = this.parseClusterNodes(this.clusterNodes);
        for (AddressPairs p : addressPairs) {
            try {
                client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(InetAddress.getByName(p.host), p.port.intValue()));
            }
            catch (UnknownHostException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.logger.info("plugin-es: successful");
        return client;
    }

    private List<AddressPairs> parseClusterNodes(String nodes) {
        return Arrays.stream(nodes.split(",")).map(e -> {
            String[] pair = e.split(":");
            return new AddressPairs(pair[0], Integer.valueOf(pair[1]));
        }).collect(Collectors.toList());
    }

    class AddressPairs {
        private String host;
        private Integer port;

        public AddressPairs(String host, Integer port) {
            this.host = host;
            this.port = port;
        }

        public String toString() {
            return "AddressPairs{host='" + this.host + '\'' + ", port=" + this.port + '}';
        }
    }
}

