package com.ohaotian.plugin.file.fastdfs;

import java.io.Serializable;

/**
 * 标题：FastDFS文件信息<br>
 * 描述：FastDFS文件信息<br>
 * 时间：2018/07/09<br>
 *
 * @author zc
 **/
public class FastdfsFileInfo implements Serializable {

    private static final long serialVersionUID = 5917817297041492072L;
    /**
     * 组名
     */
    private String groupName;
    /**
     * 文件名称（注：这里是文件上传成功后，FastDFS返回的文件名称）
     */
    private String fileName;

    public static String toFilePath(FastdfsFileInfo fastdfsFileInfo){
        return fastdfsFileInfo.getGroupName()+","+fastdfsFileInfo.getFileName();
    }

    public static FastdfsFileInfo toFastdfsFileInfo(String filePath){
        String[] temp = filePath.split(",");
        return new FastdfsFileInfo(temp[0],temp[1]);
    }

    public FastdfsFileInfo() {
    }

    public FastdfsFileInfo(String groupName, String fileName) {
        this.groupName = groupName;
        this.fileName = fileName;
    }

    @Override
    public String toString() {
        return "FastdfsFileInfo{" +
                "groupName='" + groupName + '\'' +
                ", fileName='" + fileName + '\'' +
                '}';
    }

    /**
     * 获取 组名
     *
     * @return groupName 组名
     */
    public String getGroupName() {
        return this.groupName;
    }

    /**
     * 设置 组名
     *
     * @param groupName 组名
     */
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    /**
     * 获取 文件名称（注：这里是文件上传成功后，FastDFS返回的文件名称）
     *
     * @return fileName 文件名称（注：这里是文件上传成功后，FastDFS返回的文件名称）
     */
    public String getFileName() {
        return this.fileName;
    }

    /**
     * 设置 文件名称（注：这里是文件上传成功后，FastDFS返回的文件名称）
     *
     * @param fileName 文件名称（注：这里是文件上传成功后，FastDFS返回的文件名称）
     */
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}
