/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.ftp;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.AbstractFileClient;
import com.ohaotian.plugin.file.constant.FileType;
import com.ohaotian.plugin.file.ftp.FtpConfig;
import com.ohaotian.plugin.file.ftp.FtpUtil;
import com.ohaotian.plugin.file.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;

public class FtpFileClient
extends AbstractFileClient {
    private FtpConfig ftpConfig;
    @Value(value="${plugin.file.blackType:exe;bat;js;html;dll;jsp;}")
    private String fileUploadBlackType;

    public FtpFileClient(FtpConfig ftpConfig) {
        this.ftpConfig = ftpConfig;
    }

    @Override
    public String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream) {
        byte[] bytes = FileUtils.input2byte(inputStream);
        String fileExtName = FileUtils.ext(fileName);
        if (!(!this.fileUploadBlackType.contains(FileUtils.getType(bytes)) || "txt".equals(fileExtName) || "p12".equals(fileExtName) || "pfx".equals(fileExtName) || "cer".equals(fileExtName))) {
            throw new ZTBusinessException("\u7981\u6b62\u4e0a\u4f20\u8be5\u6587\u4ef6\uff0c\u8bf7\u66f4\u6362\u540e\u91cd\u65b0\u4e0a\u4f20");
        }
        String filePath = this.getFilePath(uploadFilePath, fileName);
        FtpUtil.uploadFileByInputStream(fileName, this.ftpConfig, new ByteArrayInputStream(bytes), uploadFilePath);
        return filePath;
    }

    @Override
    public File downloadToFile(String filePath) {
        return FtpUtil.downloadFile(filePath, this.ftpConfig);
    }

    @Override
    public InputStream downLoadToInputStream(String filePath) {
        return FtpUtil.downloadByInputStream(filePath, this.ftpConfig);
    }

    @Override
    public List<String> listFiles(String filePath, String suffix) {
        return FtpUtil.listFiles(filePath, suffix, this.ftpConfig);
    }

    @Override
    protected FileType getFileType() {
        return FileType.FTP;
    }
}

