/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.fastdfs;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="fastdfs")
public class FastdfsConfig {
    private String httpAntiStealToken;
    private String httpSecretKey;
    private Integer httpTrackerHttpPort;
    private String trackerServers;

    public FastdfsConfig() {
    }

    public FastdfsConfig(String httpAntiStealToken, String httpSecretKey, Integer httpTrackerHttpPort, String trackerServers) {
        this.httpAntiStealToken = httpAntiStealToken;
        this.httpSecretKey = httpSecretKey;
        this.httpTrackerHttpPort = httpTrackerHttpPort;
        this.trackerServers = trackerServers;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("fastdfs.http_anti_steal_token", this.httpAntiStealToken);
        properties.setProperty("fastdfs.http_secret_key", this.httpSecretKey);
        properties.setProperty("fastdfs.http_tracker_http_port", this.httpTrackerHttpPort.toString());
        properties.setProperty("fastdfs.tracker_servers", this.trackerServers);
        return properties;
    }

    public boolean check() {
        return !StringUtils.isEmpty((CharSequence)this.httpAntiStealToken) && !StringUtils.isEmpty((CharSequence)this.httpSecretKey) && this.httpTrackerHttpPort != null && !StringUtils.isEmpty((CharSequence)this.trackerServers);
    }

    public String toString() {
        return "FastdfsConfig{, httpAntiStealToken='" + this.httpAntiStealToken + '\'' + ", httpSecretKey='" + this.httpSecretKey + '\'' + ", httpTrackerHttpPort='" + this.httpTrackerHttpPort + '\'' + ", trackerServers='" + this.trackerServers + '\'' + '}';
    }

    public String getHttpAntiStealToken() {
        return this.httpAntiStealToken;
    }

    public void setHttpAntiStealToken(String httpAntiStealToken) {
        this.httpAntiStealToken = httpAntiStealToken;
    }

    public String getHttpSecretKey() {
        return this.httpSecretKey;
    }

    public void setHttpSecretKey(String httpSecretKey) {
        this.httpSecretKey = httpSecretKey;
    }

    public Integer getHttpTrackerHttpPort() {
        return this.httpTrackerHttpPort;
    }

    public void setHttpTrackerHttpPort(Integer httpTrackerHttpPort) {
        this.httpTrackerHttpPort = httpTrackerHttpPort;
    }

    public String getTrackerServers() {
        return this.trackerServers;
    }

    public void setTrackerServers(String trackerServers) {
        this.trackerServers = trackerServers;
    }
}

