/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.util;

import com.ohaotian.plugin.file.util.FileType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static String ext(String filename) {
        int index = filename.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        return filename.substring(index + 1);
    }

    private static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileContent(InputStream is) {
        byte[] b = new byte[28];
        InputStream inputStream = null;
        try {
            is.read(b, 0, 28);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return FileUtils.bytesToHexString(b);
    }

    public static final byte[] input2byte(InputStream inStream) {
        try {
            ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
            byte[] buff = new byte[100];
            int rc = 0;
            while ((rc = inStream.read(buff, 0, 100)) > 0) {
                swapStream.write(buff, 0, rc);
            }
            byte[] result = swapStream.toByteArray();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getType(byte[] bytes) {
        FileType[] fileTypes;
        byte[] bytes2 = new byte[4];
        System.arraycopy(bytes, 0, bytes2, 0, 4);
        String fileHead = FileUtils.bytesToHexString(bytes2);
        if (fileHead == null || fileHead.length() == 0) {
            return null;
        }
        fileHead = fileHead.toUpperCase();
        for (FileType type : fileTypes = FileType.values()) {
            if (!fileHead.startsWith(type.getValue()) && !type.getValue().startsWith(fileHead)) continue;
            return type.name().toLowerCase();
        }
        return "";
    }

    public static void main(String[] args) throws Exception {
        byte[] bytes = FileUtils.input2byte(new FileInputStream(new File("/Users/liuzhenhua/Downloads/1516396021_apiclient_cert.p12")));
        System.out.println(FileUtils.getType(bytes));
    }
}

