/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.minio;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.AbstractFileClient;
import com.ohaotian.plugin.file.constant.FileType;
import com.ohaotian.plugin.file.minio.MinioConfig;
import com.ohaotian.plugin.file.util.FileUtils;
import io.minio.MinioClient;
import io.minio.PutObjectOptions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class MinioFileClient
extends AbstractFileClient {
    private static final Logger log = LoggerFactory.getLogger(MinioFileClient.class);
    @Value(value="${plugin.file.blackType:exe;bat;js;html;dll;jsp;zip;rar}")
    private String fileUploadBlackType;
    private MinioConfig minioConfig;

    public MinioFileClient() {
    }

    public MinioFileClient(MinioConfig minioConfig) {
        this.minioConfig = minioConfig;
    }

    @Override
    public String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream) {
        return this.uploadFileByInputStream(uploadFilePath, fileName, inputStream, null);
    }

    @Override
    public String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream, String accessAuth) {
        String fileExtName = FileUtils.ext(fileName);
        if (!StringUtils.hasText((String)fileExtName)) {
            throw new ZTBusinessException("\u7981\u6b62\u4e0a\u4f20\u65e0\u7c7b\u578b\u6587\u4ef6\uff0c\u8bf7\u66f4\u6362\u540e\u91cd\u65b0\u4e0a\u4f20");
        }
        if (!(!this.fileUploadBlackType.contains(fileExtName) || "mp4".equals(fileExtName) || "json".equals(fileExtName) || "txt".equals(fileExtName) || "p12".equals(fileExtName) || "pfx".equals(fileExtName) || "cer".equals(fileExtName))) {
            throw new ZTBusinessException("\u7981\u6b62\u4e0a\u4f20\u8be5\u6587\u4ef6\uff0c\u8bf7\u66f4\u6362\u540e\u91cd\u65b0\u4e0a\u4f20");
        }
        String objectName = uploadFilePath + fileName;
        try {
            MinioClient minioClient = new MinioClient(this.minioConfig.getEndPoint(), this.minioConfig.getAccessKeyId(), this.minioConfig.getAccessKeySecret());
            PutObjectOptions options = new PutObjectOptions((long)inputStream.available(), -1L);
            minioClient.putObject(this.minioConfig.getBucketName(), objectName, inputStream, options);
            String url = minioClient.getObjectUrl(this.minioConfig.getBucketName(), objectName);
            String path = MinioFileClient.keepAfterFourthSlash(url);
            String decodedPath = URLDecoder.decode(path, "UTF-8");
            return decodedPath;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Minio\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
            return null;
        }
    }

    public static String keepAfterFourthSlash(String url) {
        int count = 0;
        int index = 0;
        for (int i = 0; i < url.length(); ++i) {
            if (url.charAt(i) != '/' || ++count != 4) continue;
            index = i;
            break;
        }
        return url.substring(index + 1);
    }

    @Override
    public File downloadToFile(String filePath) {
        String fileName = filePath.substring(filePath.lastIndexOf("/"), filePath.length());
        String dir = System.getProperty("java.io.tmpdir");
        fileName = !dir.endsWith("/") ? dir + File.separator + fileName : dir + fileName;
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        dirFile = new File(fileName);
        try {
            int bytesRead;
            InputStream inputStream = this.downLoadToInputStream(filePath);
            FileOutputStream outputStream = new FileOutputStream(dirFile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
            ((OutputStream)outputStream).close();
            inputStream.close();
            return dirFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public InputStream downLoadToInputStream(String filePath) {
        try {
            MinioClient minioClient = new MinioClient(this.minioConfig.getEndPoint(), this.minioConfig.getAccessKeyId(), this.minioConfig.getAccessKeySecret());
            return minioClient.getObject(this.minioConfig.getBucketName(), filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected FileType getFileType() {
        return FileType.MINIO;
    }
}

