/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.obs;

import com.obs.services.model.AccessControlList;
import com.ohaotian.plugin.file.constant.ObsFileAccessAuthEnum;
import org.apache.commons.lang3.StringUtils;

public class ObsConfig {
    private String endPoint;
    private String ak;
    private String sk;
    private String bucketName;
    private String accessUrl;
    private AccessControlList obsAccessAuth;

    public ObsConfig() {
    }

    public ObsConfig(String endPoint, String ak, String sk, String bucketName, String accessUrl, String accessAuth) {
        this.endPoint = endPoint;
        this.ak = ak;
        this.sk = sk;
        this.bucketName = bucketName;
        this.accessUrl = accessUrl;
        this.obsAccessAuth = org.springframework.util.StringUtils.hasText((String)accessAuth) ? ObsFileAccessAuthEnum.getAccessControlByCode(accessAuth) : null;
    }

    public boolean check() {
        return StringUtils.isNotBlank((CharSequence)this.endPoint) && StringUtils.isNotBlank((CharSequence)this.ak) && StringUtils.isNotBlank((CharSequence)this.sk) && StringUtils.isNotBlank((CharSequence)this.bucketName);
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public String getAk() {
        return this.ak;
    }

    public String getSk() {
        return this.sk;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getAccessUrl() {
        return this.accessUrl;
    }

    public AccessControlList getObsAccessAuth() {
        return this.obsAccessAuth;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public void setAk(String ak) {
        this.ak = ak;
    }

    public void setSk(String sk) {
        this.sk = sk;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setAccessUrl(String accessUrl) {
        this.accessUrl = accessUrl;
    }

    public void setObsAccessAuth(AccessControlList obsAccessAuth) {
        this.obsAccessAuth = obsAccessAuth;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObsConfig)) {
            return false;
        }
        ObsConfig other = (ObsConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$endPoint = this.getEndPoint();
        String other$endPoint = other.getEndPoint();
        if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
            return false;
        }
        String this$ak = this.getAk();
        String other$ak = other.getAk();
        if (this$ak == null ? other$ak != null : !this$ak.equals(other$ak)) {
            return false;
        }
        String this$sk = this.getSk();
        String other$sk = other.getSk();
        if (this$sk == null ? other$sk != null : !this$sk.equals(other$sk)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        String this$accessUrl = this.getAccessUrl();
        String other$accessUrl = other.getAccessUrl();
        if (this$accessUrl == null ? other$accessUrl != null : !this$accessUrl.equals(other$accessUrl)) {
            return false;
        }
        AccessControlList this$obsAccessAuth = this.getObsAccessAuth();
        AccessControlList other$obsAccessAuth = other.getObsAccessAuth();
        return !(this$obsAccessAuth == null ? other$obsAccessAuth != null : !this$obsAccessAuth.equals(other$obsAccessAuth));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ObsConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endPoint = this.getEndPoint();
        result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
        String $ak = this.getAk();
        result = result * 59 + ($ak == null ? 43 : $ak.hashCode());
        String $sk = this.getSk();
        result = result * 59 + ($sk == null ? 43 : $sk.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        String $accessUrl = this.getAccessUrl();
        result = result * 59 + ($accessUrl == null ? 43 : $accessUrl.hashCode());
        AccessControlList $obsAccessAuth = this.getObsAccessAuth();
        result = result * 59 + ($obsAccessAuth == null ? 43 : $obsAccessAuth.hashCode());
        return result;
    }

    public String toString() {
        return "ObsConfig(endPoint=" + this.getEndPoint() + ", ak=" + this.getAk() + ", sk=" + this.getSk() + ", bucketName=" + this.getBucketName() + ", accessUrl=" + this.getAccessUrl() + ", obsAccessAuth=" + this.getObsAccessAuth() + ")";
    }
}

