/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.obs;

import com.obs.services.ObsClient;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.PutObjectResult;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.AbstractFileClient;
import com.ohaotian.plugin.file.constant.FileType;
import com.ohaotian.plugin.file.constant.ObsFileAccessAuthEnum;
import com.ohaotian.plugin.file.obs.ObsConfig;
import com.ohaotian.plugin.file.util.FileUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class ObsFileClient
extends AbstractFileClient {
    private static final Logger log = LoggerFactory.getLogger(ObsFileClient.class);
    @Value(value="${plugin.file.blackType:exe;bat;js;html;dll;jsp;zip;rar}")
    private String fileUploadBlackType;
    private ObsConfig obsConfig;

    public ObsFileClient() {
    }

    public ObsFileClient(ObsConfig obsConfig) {
        this.obsConfig = obsConfig;
    }

    @Override
    public String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream) {
        return this.uploadFileByInputStream(uploadFilePath, fileName, inputStream, null);
    }

    @Override
    public String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream, String accessAuth) {
        AccessControlList obsAccessAuth = StringUtils.hasText((String)accessAuth) ? ObsFileAccessAuthEnum.getAccessControlByCode(accessAuth) : null;
        AccessControlList obsAccessAuthByConfig = this.obsConfig.getObsAccessAuth();
        byte[] bytes = FileUtils.input2byte(inputStream);
        if (null == bytes) {
            return null;
        }
        String fileExtName = FileUtils.ext(fileName);
        if (!StringUtils.hasText((String)fileExtName)) {
            throw new ZTBusinessException("\u7981\u6b62\u4e0a\u4f20\u65e0\u7c7b\u578b\u6587\u4ef6\uff0c\u8bf7\u66f4\u6362\u540e\u91cd\u65b0\u4e0a\u4f20");
        }
        if (!(!this.fileUploadBlackType.contains(fileExtName) || "mp4".equals(fileExtName) || "json".equals(fileExtName) || "txt".equals(fileExtName) || "p12".equals(fileExtName) || "pfx".equals(fileExtName) || "cer".equals(fileExtName))) {
            throw new ZTBusinessException("\u7981\u6b62\u4e0a\u4f20\u8be5\u6587\u4ef6\uff0c\u8bf7\u66f4\u6362\u540e\u91cd\u65b0\u4e0a\u4f20");
        }
        String filePath = this.getFilePath(uploadFilePath, fileName);
        ObsClient obsClient = null;
        try {
            obsClient = new ObsClient(this.obsConfig.getAk(), this.obsConfig.getSk(), this.obsConfig.getEndPoint());
            ObjectMetadata metadata = new ObjectMetadata();
            metadata.setContentLength(Long.valueOf(bytes.length));
            PutObjectRequest request = new PutObjectRequest();
            request.setBucketName(this.obsConfig.getBucketName());
            request.setInput((InputStream)new ByteArrayInputStream(bytes));
            request.setObjectKey(filePath);
            request.setAcl(null == obsAccessAuth ? obsAccessAuthByConfig : obsAccessAuth);
            request.setMetadata(metadata);
            PutObjectResult putObjectResult = obsClient.putObject(request);
            if (putObjectResult != null) {
                String url = putObjectResult.getObjectUrl();
                url = URLDecoder.decode(url);
                url = url.replaceFirst("http://", "");
                int index = url.indexOf("/") + 1;
                if ((url = url.substring(index)).contains(".cn")) {
                    int index2 = url.indexOf("443") + 4;
                    url = url.substring(index2);
                }
                String string = url;
                return string;
            }
        }
        catch (Exception e) {
            log.error("OBS\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff08\u6587\u4ef6\uff1a{}\uff09", (Object)fileName, (Object)e);
            throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (obsClient != null) {
                try {
                    obsClient.close();
                }
                catch (IOException e) {
                    log.error("\u5173\u95edObsClient\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return null;
    }

    @Override
    public File downloadToFile(String filePath) {
        File dirFile;
        block16: {
            ObsClient obsClient = new ObsClient(this.obsConfig.getAk(), this.obsConfig.getSk(), this.obsConfig.getEndPoint());
            String fileName = UUID.randomUUID() + filePath.substring(filePath.lastIndexOf("."));
            String dir = System.getProperty("java.io.tmpdir");
            fileName = !dir.endsWith("/") ? dir + File.separator + fileName : dir + fileName;
            dirFile = new File(dir);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            dirFile = new File(fileName);
            try {
                GetObjectRequest getObjectRequest = new GetObjectRequest(this.obsConfig.getBucketName(), filePath);
                ObsObject obsObject = obsClient.getObject(getObjectRequest);
                if (obsObject == null) break block16;
                BufferedOutputStream outputStream = null;
                try {
                    int bytesRead;
                    outputStream = new BufferedOutputStream(new FileOutputStream(dirFile));
                    byte[] buffer = new byte[8192];
                    while ((bytesRead = obsObject.getObjectContent().read(buffer)) != -1) {
                        ((OutputStream)outputStream).write(buffer, 0, bytesRead);
                    }
                }
                catch (Exception e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        ObsFileClient.safeClose(outputStream);
                        ObsFileClient.safeClose(obsObject.getObjectContent());
                        throw throwable;
                    }
                }
                ObsFileClient.safeClose(outputStream);
                ObsFileClient.safeClose(obsObject.getObjectContent());
            }
            catch (Throwable e) {
                log.error("\u4eceobs\u4e0a\u4e0b\u8f7d\u6587\u4ef6,bucketName\uff1a" + this.obsConfig.getBucketName() + ";obskey\uff1a" + filePath + ";\u4e0b\u8f7d\u7684\u6587\u4ef6\u8def\u5f84:" + fileName, e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            finally {
                try {
                    obsClient.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return dirFile;
    }

    @Override
    public InputStream downLoadToInputStream(String filePath) {
        InputStream inputStream = null;
        ObsClient obsClient = new ObsClient(this.obsConfig.getAk(), this.obsConfig.getSk(), this.obsConfig.getEndPoint());
        try {
            ObsObject ossObject = obsClient.getObject(this.obsConfig.getBucketName(), filePath);
            inputStream = ossObject.getObjectContent();
        }
        catch (Throwable e) {
            log.error("\u4eceobs\u4e0a\u4e0b\u8f7d\u6587\u4ef6,bucketName\uff1a" + this.obsConfig.getBucketName() + ";obskey\uff1a" + filePath, e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            try {
                obsClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return inputStream;
    }

    @Override
    protected FileType getFileType() {
        return FileType.OBS;
    }
}

