/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.file.config;

import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.FileClientFactory;
import com.ohaotian.plugin.file.constant.FileType;
import com.ohaotian.plugin.file.cos.CosConfig;
import com.ohaotian.plugin.file.fastdfs.FastdfsConfig;
import com.ohaotian.plugin.file.ftp.FtpConfig;
import com.ohaotian.plugin.file.minio.MinioConfig;
import com.ohaotian.plugin.file.obs.ObsConfig;
import com.ohaotian.plugin.file.oss.OssConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PluginFileConfig {
    private static final Logger logger = LoggerFactory.getLogger(PluginFileConfig.class);
    @Value(value="${plugin.file.type:}")
    private String fileType;
    @Value(value="${oss.endpoint:}")
    private String endpoint;
    @Value(value="${oss.accesskey:}")
    private String accesskey;
    @Value(value="${oss.accessKeySecret:}")
    private String accessKeySecret;
    @Value(value="${oss.bucketName:}")
    private String bucketName;
    @Value(value="${oss.accessUrl:}")
    private String accessUrl;
    @Value(value="${obs.endPoint:}")
    private String obsEndPoint;
    @Value(value="${obs.ak:}")
    private String obsAk;
    @Value(value="${obs.sk:}")
    private String obsSk;
    @Value(value="${obs.bucketName:}")
    private String obsBucketName;
    @Value(value="${obs.accessUrl:}")
    private String obsAccessUrl;
    @Value(value="${obs.accessAuth:}")
    private String obsAccessAuth;
    @Value(value="${ftp.host:}")
    private String ftpHost;
    @Value(value="${ftp.user:}")
    private String ftpUser;
    @Value(value="${ftp.pwd:}")
    private String ftpPwd;
    @Value(value="${ftp.port:}")
    private Integer ftpPort;
    @Value(value="${ftp.timeout:}")
    private Integer ftpTimeout;
    @Value(value="${fastdfs.httpAntiStealToken:}")
    private String httpAntiStealToken;
    @Value(value="${fastdfs.httpSecretKey:}")
    private String httpSecretKey;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private Integer httpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String trackerServers;
    @Value(value="${minio.endPoint:}")
    private String minioEndPoint;
    @Value(value="${minio.accessKey:}")
    private String minioAccessKeyId;
    @Value(value="${minio.accessKeySecret:}")
    private String minioAccessKeySecret;
    @Value(value="${minio.accessUrl:}")
    private String minioAccessUrl;
    @Value(value="${minio.bucketName:}")
    private String minioBucketName;
    @Value(value="${cos.endPoint:}")
    private String cosEndPoint;
    @Value(value="${cos.accessKey:}")
    private String cosAccessKeyId;
    @Value(value="${cos.accessKeySecret:}")
    private String cosAccessKeySecret;
    @Value(value="${cos.region:}")
    private String cosRegion;
    @Value(value="${cos.bucketName:}")
    private String cosBucketName;

    @Bean
    public OssConfig ossConfig() {
        logger.info("plugin-file:endpoint:{}, accesskey:{}, accessKeySecret:{}, bucketName:{}, accessUrl:{}", new Object[]{this.endpoint, this.accesskey, this.accessKeySecret, this.bucketName, this.accessUrl});
        return new OssConfig(this.endpoint, this.accesskey, this.accessKeySecret, this.bucketName, this.accessUrl);
    }

    @Bean
    public ObsConfig obsConfig() {
        logger.info("plugin-file:endPoint:{}, ak:{}, sk:{}, bucketName:{}, accessUrl:{}, accessAuth:{}", new Object[]{this.obsEndPoint, this.obsAk, this.obsSk, this.obsBucketName, this.obsAccessUrl, this.obsAccessAuth});
        return new ObsConfig(this.obsEndPoint, this.obsAk, this.obsSk, this.obsBucketName, this.obsAccessUrl, this.obsAccessAuth);
    }

    @Bean
    public MinioConfig minioConfig() {
        logger.info("plugin-file:endPoint:{}, accesskey:{}, accessKeySecret:{}, bucketName:{}, accessUrl:{}", new Object[]{this.minioEndPoint, this.minioAccessKeyId, this.minioAccessKeySecret, this.minioBucketName, this.minioAccessUrl});
        return new MinioConfig(this.minioEndPoint, this.minioAccessKeyId, this.minioAccessKeySecret, this.minioBucketName, this.minioAccessUrl);
    }

    @Bean
    public FtpConfig ftpConfig() {
        logger.info("plugin-file:ftpHost:{}, ftpUser:{}, ftpPwd:{}, ftpPort:{}, ftpTimeout:{}", new Object[]{this.ftpHost, this.ftpUser, this.ftpPwd, this.ftpPort, this.ftpTimeout});
        return new FtpConfig(this.ftpHost, this.ftpUser, this.ftpPwd, this.ftpPort, this.ftpTimeout);
    }

    @Bean
    public FastdfsConfig fastdfsConfig() {
        logger.info("plugin-file:httpAntiStealToken:{}, httpSecretKey:{}, httpTrackerHttpPort:{}, trackerServers:{}", new Object[]{this.httpAntiStealToken, this.httpSecretKey, this.httpTrackerHttpPort, this.trackerServers});
        return new FastdfsConfig(this.httpAntiStealToken, this.httpSecretKey, this.httpTrackerHttpPort, this.trackerServers);
    }

    @Bean
    public CosConfig cosConfig() {
        logger.info("plugin-file:cosEndPoint:{}, cosAccessKeyId:{}, cosAccessKeySecret:{}, cosBucketName:{}, cosRegion:{}", new Object[]{this.cosEndPoint, this.cosAccessKeyId, this.cosAccessKeySecret, this.cosBucketName, this.cosRegion});
        return new CosConfig(this.cosEndPoint, this.cosAccessKeyId, this.cosAccessKeySecret, this.cosBucketName, this.cosRegion);
    }

    @Bean
    public FileClient fileClient() {
        logger.info("plugin-file:fileType:{}", (Object)this.fileType);
        if (FileType.isOss(this.fileType)) {
            if (this.ossConfig().check()) {
                return FileClientFactory.getOssClient(this.ossConfig());
            }
            throw new IllegalArgumentException("OSS \u6587\u4ef6\u4e0a\u4f20\u5c5e\u6027\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
        }
        if (FileType.isObs(this.fileType)) {
            if (this.obsConfig().check()) {
                return FileClientFactory.getObsClient(this.obsConfig());
            }
            throw new IllegalArgumentException("OBS \u6587\u4ef6\u4e0a\u4f20\u5c5e\u6027\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
        }
        if (FileType.isMinio(this.fileType)) {
            if (this.minioConfig().check()) {
                return FileClientFactory.getMinioClient(this.minioConfig());
            }
            throw new IllegalArgumentException("Minio \u6587\u4ef6\u4e0a\u4f20\u5c5e\u6027\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
        }
        if (FileType.isCos(this.fileType)) {
            if (this.cosConfig().check()) {
                return FileClientFactory.getCosClient(this.cosConfig());
            }
            throw new IllegalArgumentException("COS \u6587\u4ef6\u4e0a\u4f20\u5c5e\u6027\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
        }
        if (FileType.isFtp(this.fileType)) {
            if (this.ftpConfig().check()) {
                return FileClientFactory.getFtpClient(this.ftpConfig());
            }
            throw new IllegalArgumentException("FTP \u6587\u4ef6\u4e0a\u4f20\u5c5e\u6027\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
        }
        if (FileType.isFastdfs(this.fileType)) {
            if (this.fastdfsConfig().check()) {
                return FileClientFactory.getFastdfsClient(this.fastdfsConfig());
            }
            throw new IllegalArgumentException("FASTDFS \u6587\u4ef6\u4e0a\u4f20\u5c5e\u6027\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
        }
        FileClient fileClient = null;
        int count = 0;
        if (this.ossConfig().check()) {
            ++count;
            fileClient = FileClientFactory.getOssClient(this.ossConfig());
        }
        if (this.obsConfig().check()) {
            ++count;
            fileClient = FileClientFactory.getObsClient(this.obsConfig());
        }
        if (this.ftpConfig().check()) {
            ++count;
            fileClient = FileClientFactory.getFtpClient(this.ftpConfig());
        }
        if (this.fastdfsConfig().check()) {
            ++count;
            fileClient = FileClientFactory.getFastdfsClient(this.fastdfsConfig());
        }
        if (count == 1) {
            return fileClient;
        }
        logger.error("\u6587\u4ef6\u4e0a\u4f20\u5c5e\u6027\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
        throw new IllegalArgumentException("\u6587\u4ef6\u4e0a\u4f20\u5c5e\u6027\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
    }
}

