/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mock;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mock.exception.CaseNotExistException;
import com.ohaotian.plugin.mock.exception.MockException;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Mock {
    protected static final Log logger = LogFactory.getLog(Mock.class);
    private static Map<String, Map<String, String>> globalService = new HashMap<String, Map<String, String>>();
    private static Map<String, String> serviceCase = new HashMap<String, String>();

    public static <T> T getResponse(Class<T> type, String serviceName, String caseName) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Mock ServiceName is '" + serviceName + "' RspBO is '" + type + "' CaseName is '" + caseName + "'"));
            }
            Mock.loadServiceCase(serviceName);
            if (!serviceCase.containsKey(caseName)) {
                throw new CaseNotExistException("Mock CaseName '" + caseName + "' not exist, Please check this file '" + Mock.getServiceResourcesPath(serviceName) + "'");
            }
            String jsonStr = String.valueOf(serviceCase.get(caseName));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Mock CaseName is '" + caseName + "' the response is '" + jsonStr + "'"));
            }
            return (T)JSON.parseObject((String)jsonStr, type);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MockException("\u83b7\u53d6\u54cd\u5e94\u62a5\u6587\u5b9e\u4f8b\u5f02\u5e38: " + e.getMessage());
        }
    }

    private static void loadServiceCase(String serviceName) throws Exception {
        int i;
        if (globalService.containsKey(serviceName)) {
            serviceCase = globalService.get(serviceName);
            return;
        }
        InputStream is = Mock.class.getClassLoader().getResourceAsStream(Mock.getServiceResourcesPath(serviceName));
        if (null == is) {
            throw new FileNotFoundException("\u7f3a\u5931\u8d44\u6e90\u6587\u4ef6: '" + Mock.getServiceResourcesPath(serviceName) + "'");
        }
        byte[] buf = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((i = is.read(buf)) != -1) {
            baos.write(buf, 0, i);
        }
        String data = baos.toString("UTF-8");
        serviceCase = (Map)JSON.parseObject((String)data, Map.class);
        is.close();
        globalService.put(serviceName, serviceCase);
    }

    private static String getServiceResourcesPath(String serviceName) {
        return "mock/" + serviceName + ".json";
    }
}

