package com.ohaotian.plugin.mq.proxy;

import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;

import java.util.Properties;

/**
 * 标题：默认消息配置实现
 * <p>
 * 说明：默认消息配置实现
 * <br>
 * 时间：2018/06/26<br>
 * 版权：copyright © 2018 www.tydic.com Inc. All rights reserved.
 * </p>
 *
 * @author Please creater enter the name
 * @author ZhangCheng
 */
public class DefaultProxyMessageConfig implements ProxyMessageConfig {
    /**
     * 主题
     */
    private String subject;
    /**
     * 标签
     */
    private String[] tags;
    /**
     * 策略
     */
    private String strategy;
    /**
     * ID
     */
    private String id;
    /**
     * 消息类型
     */
    private ProxyMessageType[] messageTypes = new ProxyMessageType[]{ProxyMessageType.ONEWAY, ProxyMessageType.TRANSACTION, ProxyMessageType.SYNCHRONIZATION, ProxyMessageType.ASYNCHRONOUS};
    /**
     * 属性
     */
    private Properties properties;

    /**
     * 队列
     * @return
     */
    private String queueName;

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String[] getTags() {
        return tags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    public ProxyMessageType[] supportMessageTypes() {
        return messageTypes;
    }

    public ProxyMessageType[] getMessageTypes() {
        return messageTypes;
    }

    public void setMessageTypes(ProxyMessageType[] messageTypes) {
        this.messageTypes = messageTypes;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return properties;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }
    @Override
    public String getQueueName() {
        return queueName;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getStrategy() {
        return strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }


}
