package com.ohaotian.plugin.mq.proxy;

import java.io.Serializable;

/**
 * 标题：消息类
 * <p>
 * 说明：消息类
 * <br>
 * 时间：2018/06/26<br>
 * 版权：copyright © 2018 www.tydic.com Inc. All rights reserved.
 * </p>
 *
 * @author Please creater enter the name
 * @author ZhangCheng
 */
public class ProxyMessage implements Serializable {

    private static final long serialVersionUID = 1908095534876880579L;

    /**
     * 必传 消息ID
     */
    private String messageId;
    /**
     * 必传 主题
     */
    private String subject;
    /**
     * 必传 标签
     */
    private String tag;
    /**
     * 必传 消息内容
     */
    private String content;

    /**
     * RabbitMQ  队列名称
     */
    private String queueName;
    private int delaySendTime;

    public ProxyMessage() {
    }

    public ProxyMessage(String subject, String queueName,String messageId, String tag, String content) {
        this.subject = subject;
        this.queueName = queueName;
        this.messageId = messageId;
        this.tag = tag;
        this.content = content;
    }
    public ProxyMessage(String subject, String tag, String content) {
        this.subject = subject;
        this.tag = tag;
        this.content = content;
        this.delaySendTime=0;
    }

    @Override
    public String toString() {
        return "ProxyMessage{" +
                "messageId='" + messageId + '\'' +
                ", subject='" + subject + '\'' +
                ", tag='" + tag + '\'' +
                ", content='" + content + '\'' +
                '}';
    }

    /**
     * 获取 必传 消息ID
     *
     * @return messageId 必传 消息ID
     */
    public String getMessageId() {
        return this.messageId;
    }

    /**
     * 设置 必传 消息ID
     *
     * @param messageId 必传 消息ID
     */
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    /**
     * 获取 必传 主题
     *
     * @return subject 必传 主题
     */
    public String getSubject() {
        return this.subject;
    }

    /**
     * 获取 必传 标签
     *
     * @return tag 必传 标签
     */
    public String getTag() {
        return this.tag;
    }

    /**
     * 获取 必传 消息内容
     *
     * @return content 必传 消息内容
     */
    public String getContent() {
        return this.content;
    }

    /**
     * RabbitMQ  队列名称
     * @return
     */
    public String getQueueName() {
        return queueName;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getDelaySendTime() {
        return delaySendTime;
    }

    public void setDelaySendTime(int delaySendTime) {
        this.delaySendTime = delaySendTime;
    }
}
