package com.ohaotian.plugin.mq.proxy.ext;

import com.ohaotian.plugin.mq.proxy.CacheStore;
import com.ohaotian.plugin.mq.proxy.status.ProxyTransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyMqTransactionChecker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final boolean isDebugEnable = logger.isDebugEnabled();
    /** 本地事务执行时间过长，check机制过来时，先添加一条 */
    public static final Integer PRODUCT_SEND_STATUS_TIMETOOLONG = 2;
    /** 缓存超时时间 单位毫秒 */
    public static final long    MQ_EXPIRE                       = 7200000;
    /** 本地事务check超时时间 单位秒 */
    public static final int     MQ_TRAN_CHECK_EXPIRE            = 600;


    private CacheStore cacheStore;

    public ProxyTransactionStatus check(String msgId, String key, String topic, String tag) {
        String status = (String) cacheStore.get(msgId);
        if (status != null) {
            if (ProxyTransactionStatus.COMMIT.toString().equals(status)) {
                if (isDebugEnable) {
                    logger.debug("check msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "} key={" + key + "}send message success!");
                }
                try {
                    cacheStore.delete(msgId);
                    cacheStore.delete("C_" + msgId);
                } catch (Exception e) {
                    logger.error("delete redis key{" + msgId + "} and key {" + "C_" + msgId + "} error", e);
                }
                return ProxyTransactionStatus.COMMIT;
            } else if (ProxyTransactionStatus.ROLLBACK.toString().equals(status)) {
                if (isDebugEnable) {
                    logger.debug("check  msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "} key={" + key + "}send message fail!");
                }
                try {
                    cacheStore.delete(msgId);
                    cacheStore.delete("C_" + msgId);
                } catch (Exception e) {
                    logger.error("delete redis中key{" + msgId + "} and key {" + "C_" + msgId + "} error", e);
                }
                return ProxyTransactionStatus.ROLLBACK;
            } else {
                logger.error("unknow mq trans{" + status + "}msgId{" + msgId + "}");
                return ProxyTransactionStatus.ROLLBACK;
            }
        } else {
            Integer cstatus = (Integer) cacheStore.get("C_" + msgId);
            if (cstatus != null) {
                Long dateTime = cacheStore.getExpireTimeByKey("C_" + msgId);
                if (dateTime != null && (dateTime == -1 || dateTime == -2)) {
                    cacheStore.delete(msgId);
                    if (isDebugEnable) {
                        logger.debug("check msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "}  key={" + key + "}----too long time，delete message！");
                    }
                    return ProxyTransactionStatus.ROLLBACK;
                } else {
                    if (isDebugEnable) {
                        logger.debug("check msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "}  key={" + key + "} unknow status!");
                    }
                    return ProxyTransactionStatus.UNKNOW;
                }
            } else {
                if (isDebugEnable) {
                    logger.debug("check msgId{" + msgId + "} topic={" + topic + "} tag={" + tag + "}  key={" + key + "} first check empty，add a check!");
                }
                // 设置的超时时间为当前时间
                cacheStore.set("C_" + msgId, PRODUCT_SEND_STATUS_TIMETOOLONG, (int) (MQ_EXPIRE / 1000));
            }

            return ProxyTransactionStatus.UNKNOW;
        }
    }

    public void setCacheStore(CacheStore cacheStore) {
        this.cacheStore = cacheStore;
    }
}
