package com.ohaotian.plugin.mq.proxy.ext.rabbitmq;

import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.config.ApolloConfigVO;
import com.ohaotian.plugin.mq.proxy.constants.Strategy;
import com.ohaotian.plugin.mq.proxy.impl.ConsumerRegisterInfo;
import com.ohaotian.plugin.mq.proxy.impl.MQRegister;
import com.rabbitmq.client.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @描述：
 * @作者： 李佳琪
 * @时间 2020-04-10
 */

/**
 * 交换机/路由 == topic ？
 * 队列 = tag ？
 */

public class RabbitMQMessageConsumerRegister implements MQRegister, ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger(this.getClass().getName());
    private Properties mergedProps = new Properties();
    private boolean started;
    private Channel channel;
    private String exchangeName;

    @Override
    public void register(ConsumerRegisterInfo consumerInfo, ApolloConfigVO apolloConfigVO) {
        String subject = consumerInfo.getSubject();
        String queueName = consumerInfo.getQueueName();
        Set<String> tags = consumerInfo.getTags();
        List<String> collect = tags.stream().collect(Collectors.toList());
        if (collect.size() != 1) {
            throw new IllegalArgumentException("Tags must have 1 element");
        }
        ProxyMessageType[] messageTypes = consumerInfo.getMessageTypes();
        for (ProxyMessageType messageType : messageTypes) {
            if (supportConcurrently(messageType)) {
                continue;
            }
            throw new UnsupportedOperationException("Unsuppoorted messageType[" + messageType + "] for subject[" + consumerInfo.getSubject() + "]");
        }
        try {
            Properties consumerProps = consumerInfo.getProperties();
            exchangeName = consumerProps.getProperty("mq.exchangeName", mergedProps.getProperty("mq.exchangeName"));
            channel = RabbitMQUtil.getChannelInstance("消费者,队列：" + queueName, mergedProps);
            //声明交换机（分发:发布/订阅模式）
            channel.exchangeDeclare(exchangeName, BuiltinExchangeType.TOPIC);
            //声明队列
            channel.queueDeclare(queueName, false, false, false, null);
            //将队列绑定到交换机
            channel.queueBind(queueName, exchangeName, subject);
            //监听对象
            RabbitMqMessageListener rabbitMqMessageListener = new RabbitMqMessageListener(queueName, false, collect.get(0), channel, consumerInfo.getConsumerWrappers());
            //监听
            channel.basicConsume(queueName, rabbitMqMessageListener);
            logger.info("消费者启动注册，交换机="+exchangeName
                    +"，队列名称=" + queueName);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static ProxyMessage getMessage(ProxyMessage proxyMessage) {
        //can do someThing
        return proxyMessage;
    }


    @Override
    public boolean support(String strategy) {
        return this.strategySupported(strategy);
    }

    @Override
    public void startup() {
        if (started) {
            return;
        }
        started = true;
    }

    @Override
    public void shutdown() {
        if (!started) {
            return;
        }
        started = false;
    }

    public static boolean strategySupported(String strategy) {
        return Strategy.isRabbitMQ(strategy);
    }

    private boolean supportConcurrently(ProxyMessageType messageType) {
        return messageType == ProxyMessageType.ASYNCHRONOUS || messageType == ProxyMessageType.SYNCHRONIZATION || messageType == ProxyMessageType.ONEWAY || messageType == ProxyMessageType.TRANSACTION;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map<String, Properties> propsMapping = applicationContext.getBeansOfType(Properties.class);
        if (propsMapping != null) {
            for (Properties props : propsMapping.values()) {
                CollectionUtils.mergePropertiesIntoMap(props, mergedProps);
            }
        }
    }
}
