/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy;

import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class ProxyMessageLog
implements Serializable {
    private static final long serialVersionUID = -8785431206127922660L;
    private String messageId;
    private String subject;
    private String tag;
    private String bornTime;
    private String consumeTime;
    private String duringTime;

    public ProxyMessageLog(ProxyMessage proxyMessage) {
        this.messageId = proxyMessage.getMessageId();
        this.subject = proxyMessage.getSubject();
        this.tag = proxyMessage.getTag();
        if (proxyMessage.getBornTime() != 0L) {
            this.bornTime = this.parseTime(proxyMessage.getBornTime());
        }
        if (proxyMessage.getConsumeTime() != 0L) {
            this.consumeTime = this.parseTime(proxyMessage.getConsumeTime());
        }
        if (proxyMessage.getBornTime() != 0L && proxyMessage.getConsumeTime() != 0L) {
            long timeDifference = proxyMessage.getConsumeTime() - proxyMessage.getBornTime();
            this.duringTime = timeDifference + "ms";
        }
    }

    private String parseTime(long time) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault());
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return dateTime.format(formatter);
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTag() {
        return this.tag;
    }

    public String getBornTime() {
        return this.bornTime;
    }

    public String getConsumeTime() {
        return this.consumeTime;
    }

    public String getDuringTime() {
        return this.duringTime;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setBornTime(String bornTime) {
        this.bornTime = bornTime;
    }

    public void setConsumeTime(String consumeTime) {
        this.consumeTime = consumeTime;
    }

    public void setDuringTime(String duringTime) {
        this.duringTime = duringTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProxyMessageLog)) {
            return false;
        }
        ProxyMessageLog other = (ProxyMessageLog)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$bornTime = this.getBornTime();
        String other$bornTime = other.getBornTime();
        if (this$bornTime == null ? other$bornTime != null : !this$bornTime.equals(other$bornTime)) {
            return false;
        }
        String this$consumeTime = this.getConsumeTime();
        String other$consumeTime = other.getConsumeTime();
        if (this$consumeTime == null ? other$consumeTime != null : !this$consumeTime.equals(other$consumeTime)) {
            return false;
        }
        String this$duringTime = this.getDuringTime();
        String other$duringTime = other.getDuringTime();
        return !(this$duringTime == null ? other$duringTime != null : !this$duringTime.equals(other$duringTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProxyMessageLog;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $bornTime = this.getBornTime();
        result = result * 59 + ($bornTime == null ? 43 : $bornTime.hashCode());
        String $consumeTime = this.getConsumeTime();
        result = result * 59 + ($consumeTime == null ? 43 : $consumeTime.hashCode());
        String $duringTime = this.getDuringTime();
        result = result * 59 + ($duringTime == null ? 43 : $duringTime.hashCode());
        return result;
    }

    public String toString() {
        return "ProxyMessageLog(messageId=" + this.getMessageId() + ", subject=" + this.getSubject() + ", tag=" + this.getTag() + ", bornTime=" + this.getBornTime() + ", consumeTime=" + this.getConsumeTime() + ", duringTime=" + this.getDuringTime() + ")";
    }
}

