/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.mq.proxy.ext.tonglkq;

import com.alibaba.fastjson.JSON;
import com.ohaotian.license.verify.service.LicenseVerifyService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageType;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.ohaotian.plugin.mq.proxy.callback.ProxyLocalTransactionExecuter;
import com.ohaotian.plugin.mq.proxy.callback.ProxySendCallback;
import com.ohaotian.plugin.mq.proxy.ext.ProxyMessageProducerEx;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageException;
import com.tongtech.tmqi.QueueConnectionFactory;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;

public class TongLKQMessageSender
implements ProxyMessageProducerEx,
ApplicationContextAware,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(TongLKQMessageSender.class);
    private LicenseVerifyService licenseVerifyService;
    private Environment environment;
    private final Map<ProxyMessageType, Set<String>> typeTagsMapping;
    private ProxyMessageConfig messageConfig;
    private final String subject;
    private volatile QueueConnection queueConnection;
    private volatile QueueSession queueSession;
    private volatile boolean isConnected = false;
    private final ReentrantLock lock = new ReentrantLock();

    public TongLKQMessageSender(ProxyMessageConfig messageConfig, Map<ProxyMessageType, Set<String>> typeTagsMapping) {
        log.info("[" + this.getClass().getName() + "] required properties[mq.endpoint]");
        this.subject = messageConfig.getSubject();
        this.messageConfig = messageConfig;
        this.typeTagsMapping = typeTagsMapping;
    }

    @Override
    public void startup() {
        log.debug("\u5f00\u59cb\u521b\u5efa\u751f\u4ea7\u8005\u5bf9\u8c61bean");
        this.initConnection();
    }

    private void initConnection() {
        this.lock.lock();
        try {
            if (this.isConnected && this.queueSession != null && this.queueConnection != null) {
                return;
            }
            if (!this.licenseVerifyService.verify()) {
                throw new ZTBusinessException("\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            String tlqUrl = this.environment.getProperty("mq.endpoint");
            if (tlqUrl == null || tlqUrl.trim().isEmpty()) {
                throw new ZTBusinessException("mq.endpoint\u914d\u7f6e\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
            }
            this.closeResources();
            QueueConnectionFactory queueConnectionFactory = new QueueConnectionFactory();
            queueConnectionFactory.setProperty("tmqiAddressList", tlqUrl);
            this.queueConnection = queueConnectionFactory.createQueueConnection();
            this.queueSession = this.queueConnection.createQueueSession(false, 1);
            this.queueConnection.start();
            this.isConnected = true;
            log.debug("TongLKQ\u8fde\u63a5\u548c\u4f1a\u8bdd\u521d\u59cb\u5316\u6210\u529f");
        }
        catch (Exception e) {
            log.error("TongLKQ\u521d\u59cb\u5316\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            this.closeResources();
            throw new ProxyMessageException("\u521d\u59cb\u5316TongLKQ\u8fde\u63a5\u5931\u8d25", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void shutdown() {
        this.lock.lock();
        try {
            this.closeResources();
            log.debug("TongLKQ\u8fde\u63a5\u548c\u4f1a\u8bdd\u5df2\u5173\u95ed");
        }
        finally {
            this.lock.unlock();
        }
    }

    private void closeResources() {
        this.isConnected = false;
        if (this.queueSession != null) {
            try {
                this.queueSession.close();
            }
            catch (JMSException e) {
                log.warn("\u5173\u95edQueueSession\u5931\u8d25", (Throwable)e);
            }
            finally {
                this.queueSession = null;
            }
        }
        if (this.queueConnection != null) {
            try {
                this.queueConnection.close();
            }
            catch (JMSException e) {
                log.warn("\u5173\u95edQueueConnection\u5931\u8d25", (Throwable)e);
            }
            finally {
                this.queueConnection = null;
            }
        }
    }

    @Override
    public ProxySendResult send(ProxyMessage message) {
        ProxySendResult proxySendResult;
        log.warn("TongLKQMessageSender\u8f93\u51fa\u65e5\u5fd7\uff1a" + JSON.toJSONString((Object)message));
        if (!this.licenseVerifyService.verify()) {
            throw new ZTBusinessException("\u8bc1\u4e66\u5df2\u8fc7\u671f\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        QueueSender queueSender = null;
        try {
            if (!this.isConnected || this.queueSession == null || this.queueConnection == null) {
                log.warn("\u8fde\u63a5\u5df2\u5173\u95ed\u6216\u672a\u521d\u59cb\u5316\uff0c\u5c1d\u8bd5\u91cd\u65b0\u521d\u59cb\u5316\u8fde\u63a5");
                this.initConnection();
            }
            TextMessage sendMessage = this.queueSession.createTextMessage(message.getContent());
            String messageId = message.getMessageId();
            if (messageId == null || messageId.trim().isEmpty()) {
                messageId = UUID.randomUUID().toString();
            }
            if (sendMessage != null) {
                sendMessage.setStringProperty("messageId", messageId);
                sendMessage.setStringProperty("tag", message.getTag());
                Queue queue = this.queueSession.createQueue(message.getSubject());
                queueSender = this.queueSession.createSender(queue);
                queueSender.send((Message)sendMessage);
                proxySendResult = this.getProxySendResult(true, messageId);
            } else {
                proxySendResult = this.getProxySendResult(false, messageId);
            }
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
            this.closeResources();
            throw new ProxyMessageException("\u53d1\u9001\u4e3b\u9898[" + message.getSubject() + "]\u6807\u7b7e[" + message.getTag() + "]\u5931\u8d25", e);
        }
        finally {
            if (queueSender != null) {
                try {
                    queueSender.close();
                }
                catch (JMSException e) {
                    log.warn("\u5173\u95edQueueSender\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return proxySendResult;
    }

    private ProxySendResult getProxySendResult(boolean send, String messageId) {
        ProxySendResult proxySendResult = new ProxySendResult();
        proxySendResult.setMsgId(messageId);
        proxySendResult.setStatus(send ? "SEND_OK" : "SEND_FAIL");
        return proxySendResult;
    }

    @Override
    public void send(ProxyMessage message, ProxySendCallback sendCallback) {
        log.error("tlq\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
        throw new UnsupportedOperationException("tlq not support send with callback");
    }

    @Override
    public void sendOneway(ProxyMessage message) {
        log.error("tlq\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
        throw new UnsupportedOperationException("tlq not support sendOneway");
    }

    @Override
    public ProxySendResult sendInTransaction(ProxyMessage proxyMessage, ProxyLocalTransactionExecuter localTransactionExecuter, Object arg) {
        log.error("tlq\u4e0d\u652f\u6301\u8be5\u65b9\u6cd5");
        throw new UnsupportedOperationException("tlq not support sendInTransaction");
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.licenseVerifyService = (LicenseVerifyService)applicationContext.getBean(LicenseVerifyService.class);
        this.environment = applicationContext.getEnvironment();
    }

    public void destroy() throws Exception {
        this.shutdown();
    }
}

