/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.nosql.config;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class EsRetryAspect {
    private static final Logger log = LoggerFactory.getLogger(EsRetryAspect.class);
    private static final int MAX_RETRY = 3;
    private static final long DELAY_MS = 1000L;

    @Around(value="execution(* com.ohaotian.plugin.nosql.es.EsManagerImpl.*(..)) && throwing(java.lang.Exception)")
    public Object retryMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        int retryCount = 0;
        Throwable lastException = null;
        while (retryCount < 3) {
            try {
                return joinPoint.proceed();
            }
            catch (Throwable e) {
                lastException = e;
                log.warn("\u65b9\u6cd5{}\u91cd\u8bd5\u7b2c{}\u6b21\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{joinPoint.getSignature().getName(), ++retryCount, e.getMessage()});
                Thread.sleep(1000L * (long)retryCount);
            }
        }
        log.error("\u65b9\u6cd5{}\u91cd\u8bd5{}\u6b21\u540e\u4ecd\u5931\u8d25", new Object[]{joinPoint.getSignature().getName(), 3, lastException});
        throw lastException;
    }
}

