/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.nosql.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.nosql.NosqlClient;
import com.ohaotian.plugin.nosql.NosqlManager;
import com.ohaotian.plugin.nosql.bo.NosqlAddBatchReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlAddBatchRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlAddSingleReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlAddSingleRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlBO;
import com.ohaotian.plugin.nosql.bo.NosqlDeleteBatchReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlDeleteBatchRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlDeleteByBuilderReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlDeleteByBuilderRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlDeleteSingleReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlDeleteSingleRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlMapBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryByBuilderReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryByBuilderRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateArrayFieldReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateArrayFieldReqBO2;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateArrayFieldRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateBatchByBuilderReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateBatchByBuilderRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateBatchReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateBatchRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateSingleReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateSingleRsqBO;
import com.ohaotian.plugin.nosql.impl.NosqlBuilder;
import com.ohaotian.plugin.nosql.util.ExecutorProcessPool;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NosqlClientImpl
implements NosqlClient {
    private static final Logger log = LoggerFactory.getLogger(NosqlClientImpl.class);
    private NosqlManager nosqlManager;

    @Override
    public void setNosqlManager(NosqlManager nosqlManager) {
        this.nosqlManager = nosqlManager;
    }

    @Override
    public NosqlQueryByBuilderRsqBO queryByBuilder(NosqlQueryByBuilderReqBO reqBO) {
        NosqlQueryByBuilderRsqBO rsqBO = new NosqlQueryByBuilderRsqBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getIndex())) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1a\u7d22\u5f15\u540d\u79f0[index]\u4e0d\u80fd\u4e3a\u7a7a");
            return rsqBO;
        }
        NosqlBuilder nosqlBuilder = reqBO.getNosqlBuilder();
        try {
            if (nosqlBuilder == null) {
                rsqBO = this.nosqlManager.queryAll(reqBO.getIndex(), 1, 10);
                return rsqBO;
            }
            if (nosqlBuilder.getNosqlQueryGroupList() == null && nosqlBuilder.getNosqlGroupList() == null && nosqlBuilder.getNosqlOrderList() == null && nosqlBuilder.getNosqlQueryAggList() == null) {
                rsqBO = this.nosqlManager.queryAll(reqBO.getIndex(), nosqlBuilder.getPageNo(), nosqlBuilder.getPageSize());
                return rsqBO;
            }
            if (nosqlBuilder.getNosqlQueryAggList() != null) {
                rsqBO = this.nosqlManager.aggregateByFields(reqBO.getIndex(), nosqlBuilder);
                return rsqBO;
            }
            rsqBO = this.nosqlManager.queryForBuilder(reqBO.getIndex(), nosqlBuilder);
            return rsqBO;
        }
        catch (Exception e) {
            if (e.getMessage().contains("reason=no such index")) {
                String resultStr = "[]";
                rsqBO.setDocumentStr(resultStr);
                rsqBO.setTotal(0);
                rsqBO.setRecordsTotal(0);
                if (nosqlBuilder == null) {
                    rsqBO.setPageNo(1);
                    rsqBO.setPageSize(10);
                } else {
                    rsqBO.setPageNo(nosqlBuilder.getPageNo());
                    rsqBO.setPageSize(nosqlBuilder.getPageSize());
                }
                rsqBO.setJsonSource("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
            } else {
                rsqBO.setRespCode("8888");
                rsqBO.setRespDesc("\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
                e.printStackTrace();
            }
            return rsqBO;
        }
    }

    @Override
    public NosqlAddSingleRsqBO addSingle(NosqlAddSingleReqBO reqBO) {
        NosqlAddSingleRsqBO rsqBO = new NosqlAddSingleRsqBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getIndex())) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u65b0\u589e\u6570\u636e\uff08\u5355\u6761\uff09\u5931\u8d25\uff1a\u7d22\u5f15\u540d\u79f0[index]\u4e0d\u80fd\u4e3a\u7a7a");
            return rsqBO;
        }
        if (reqBO.getNosqlBO() == null) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u65b0\u589e\u6570\u636e\uff08\u5355\u6761\uff09\u5931\u8d25\uff1a\u5185\u5bb9BO[nosqlBO]\u4e0d\u80fd\u4e3a\u7a7a");
            return rsqBO;
        }
        if (reqBO.getNosqlBO().getObject() == null) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u65b0\u589e\u6570\u636e\uff08\u5355\u6761\uff09\u5931\u8d25\uff1a\u6cdb\u5316BO[nosqlBO.object]\u4e0d\u80fd\u4e3a\u7a7a");
            return rsqBO;
        }
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getNosqlBO().getObject()));
        try {
            String result = this.nosqlManager.addData(reqBO.getIndex(), reqBO.getNosqlBO().getId(), jsonObject);
            if (StringUtils.isNotBlank((CharSequence)result)) {
                rsqBO.setRespDesc(result);
                return rsqBO;
            }
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc(result);
            return rsqBO;
        }
        catch (Exception e) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u5355\u4e2a\u65b0\u589e\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
            return rsqBO;
        }
    }

    @Override
    public NosqlAddBatchRsqBO addBatch(NosqlAddBatchReqBO reqBO) {
        NosqlAddBatchRsqBO rsqBO = new NosqlAddBatchRsqBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getIndex())) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u65b0\u589e\u6570\u636e\uff08\u6279\u91cf\uff09\u5931\u8d25\uff1a\u7d22\u5f15\u540d\u79f0[index]\u4e0d\u80fd\u4e3a\u7a7a");
            return rsqBO;
        }
        if (reqBO.getNosqlBOList() == null || reqBO.getNosqlBOList().size() == 0) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u65b0\u589e\u6570\u636e\uff08\u6279\u91cf\uff09\u5931\u8d25\uff1a\u5185\u5bb9BO[nosqlBOList]\u4e0d\u80fd\u4e3a\u7a7a");
            return rsqBO;
        }
        ArrayList<Map<String, JSONObject>> list = new ArrayList<Map<String, JSONObject>>();
        for (NosqlBO nosqlBO : reqBO.getNosqlBOList()) {
            if (nosqlBO.getObject() == null) continue;
            HashMap<String, JSONObject> itemMap = new HashMap<String, JSONObject>();
            JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)nosqlBO.getObject()));
            itemMap.put(nosqlBO.getId(), jsonObject);
            list.add(itemMap);
        }
        try {
            this.nosqlManager.addBatch(reqBO.getIndex(), list);
        }
        catch (Exception e) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u6279\u91cf\u65b0\u589e\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
        }
        return rsqBO;
    }

    @Override
    public NosqlUpdateSingleRsqBO updateSingle(NosqlUpdateSingleReqBO reqBO) {
        NosqlUpdateSingleRsqBO rsqBO = new NosqlUpdateSingleRsqBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getIndex())) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u66f4\u65b0\u6570\u636e\uff08\u5355\u6761\uff09\u5931\u8d25\uff1a\u7d22\u5f15\u540d\u79f0[index]\u4e0d\u80fd\u4e3a\u7a7a");
            return rsqBO;
        }
        if (reqBO.getNosqlBO() == null) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u66f4\u65b0\u6570\u636e\uff08\u5355\u6761\uff09\u5931\u8d25\uff1a\u5185\u5bb9BO[nosqlBO]\u4e0d\u80fd\u4e3a\u7a7a");
            return rsqBO;
        }
        if (reqBO.getNosqlBO().getObject() == null) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u66f4\u65b0\u6570\u636e\uff08\u5355\u6761\uff09\u5931\u8d25\uff1a\u6cdb\u5316BO[nosqlBO.object]\u4e0d\u80fd\u4e3a\u7a7a");
            return rsqBO;
        }
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getNosqlBO().getObject()));
        Boolean result = false;
        try {
            result = reqBO.getForNull() != false ? this.nosqlManager.updateDataForNull(reqBO.getIndex(), reqBO.getNosqlBO().getId(), jsonObject) : this.nosqlManager.updateData(reqBO.getIndex(), reqBO.getNosqlBO().getId(), jsonObject);
            if (result.booleanValue()) {
                return rsqBO;
            }
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u6267\u884c\u5931\u8d25");
        }
        catch (Exception e) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u66f4\u65b0\u6570\u636e\uff08\u5355\u6761\uff09\u5931\u8d25\uff1a" + e.getMessage());
        }
        return rsqBO;
    }

    @Override
    public NosqlUpdateBatchRsqBO updateBatch(NosqlUpdateBatchReqBO reqBO) {
        NosqlUpdateBatchRsqBO rsqBO = new NosqlUpdateBatchRsqBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getIndex())) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u6279\u91cf\u66f4\u65b0\u6570\u636e\uff08\u53ea\u66f4\u65b0\u6709\u503c\u7684\u5b57\u6bb5\uff09\u5931\u8d25\uff1a\u7d22\u5f15\u540d\u79f0[index]\u4e0d\u80fd\u4e3a\u7a7a");
            return rsqBO;
        }
        HashMap<String, Map<String, Object>> maps = new HashMap<String, Map<String, Object>>();
        if (reqBO.getIds() != null) {
            for (String id : reqBO.getIds()) {
                if (reqBO.getMaps() == null || reqBO.getMaps().isEmpty()) continue;
                maps.put(id, reqBO.getMaps());
            }
        }
        if (reqBO.getNosqlBOList() != null) {
            for (NosqlMapBO nosqlBO : reqBO.getNosqlBOList()) {
                if (nosqlBO.getMaps() == null || nosqlBO.getMaps().isEmpty()) continue;
                maps.put(nosqlBO.getId(), nosqlBO.getMaps());
            }
        }
        Boolean result = false;
        try {
            result = reqBO.getForNull() != false ? this.nosqlManager.updateBatchDataForNull(reqBO.getIndex(), maps) : this.nosqlManager.updateBatchData(reqBO.getIndex(), maps);
            if (!result.booleanValue()) {
                rsqBO.setRespCode("8888");
                rsqBO.setRespDesc("\u6279\u91cf\u66f4\u65b0\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u6279\u91cf\u66f4\u65b0\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
            e.printStackTrace();
        }
        return rsqBO;
    }

    @Override
    public NosqlUpdateArrayFieldRsqBO updateArrayField(NosqlUpdateArrayFieldReqBO reqBO) {
        NosqlUpdateArrayFieldRsqBO rsqBO;
        block11: {
            String reqJson = JSON.toJSONString((Object)reqBO);
            log.info("\u6279\u91cf\u66f4\u65b0\u6570\u636e\uff08\u53ea\u66f4\u65b0\u6709\u503c\u7684\u5b57\u6bb5\uff09\u5165\u53c2\uff1a" + reqJson);
            NosqlUpdateArrayFieldReqBO2 reqBOTemp = (NosqlUpdateArrayFieldReqBO2)JSON.parseObject((String)reqJson, NosqlUpdateArrayFieldReqBO2.class);
            rsqBO = new NosqlUpdateArrayFieldRsqBO();
            if (StringUtils.isBlank((CharSequence)reqBO.getIndex())) {
                rsqBO.setRespCode("8888");
                rsqBO.setRespDesc("\u6279\u91cf\u66f4\u65b0\u6570\u636e\uff08\u53ea\u66f4\u65b0\u6709\u503c\u7684\u5b57\u6bb5\uff09\u5931\u8d25\uff1a\u7d22\u5f15\u540d\u79f0[index]\u4e0d\u80fd\u4e3a\u7a7a");
                return rsqBO;
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getId()) && reqBO.getNosqlBuilder() == null) {
                rsqBO.setRespCode("8888");
                rsqBO.setRespDesc("\u6279\u91cf\u66f4\u65b0\u6570\u636e\uff08\u53ea\u66f4\u65b0\u6709\u503c\u7684\u5b57\u6bb5\uff09\u5931\u8d25\uff1a\u6587\u6863ID[id]\u548cnosql\u6784\u9020\u5668[nosqlBuilder]\u81f3\u5c11\u6709\u4e00\u4e2a\u4e0d\u80fd\u4e3a\u7a7a");
                return rsqBO;
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getArrayFieldName())) {
                rsqBO.setRespCode("8888");
                rsqBO.setRespDesc("\u6279\u91cf\u66f4\u65b0\u6570\u636e\uff08\u53ea\u66f4\u65b0\u6709\u503c\u7684\u5b57\u6bb5\uff09\u5931\u8d25\uff1a\u6570\u7ec4\u5b57\u6bb5\u540d\u79f0[arrayFieldName]\u4e0d\u80fd\u4e3a\u7a7a");
                return rsqBO;
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getIdFieldName())) {
                rsqBO.setRespCode("8888");
                rsqBO.setRespDesc("\u6279\u91cf\u66f4\u65b0\u6570\u636e\uff08\u53ea\u66f4\u65b0\u6709\u503c\u7684\u5b57\u6bb5\uff09\u5931\u8d25\uff1a\u6570\u7ec4ID\u5b57\u6bb5\u540d\u79f0[idFieldName]\u4e0d\u80fd\u4e3a\u7a7a");
                return rsqBO;
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getIdValue())) {
                rsqBO.setRespCode("8888");
                rsqBO.setRespDesc("\u6279\u91cf\u66f4\u65b0\u6570\u636e\uff08\u53ea\u66f4\u65b0\u6709\u503c\u7684\u5b57\u6bb5\uff09\u5931\u8d25\uff1a\u6570\u7ec4ID[idValue]\u4e0d\u80fd\u4e3a\u7a7a");
                return rsqBO;
            }
            try {
                if (reqBO.getIsSynch().booleanValue()) {
                    try {
                        if (StringUtils.isBlank((CharSequence)reqBO.getId())) {
                            String res = this.nosqlManager.updateByScript(reqBO.getIndex(), reqBO.getNosqlBuilder(), reqBO.getArrayFieldName(), reqBO.getIdFieldName(), reqBO.getIdValue(), reqBOTemp.getMaps());
                            rsqBO.setRespDesc(res);
                            break block11;
                        }
                        this.nosqlManager.updateByScript(reqBO.getIndex(), reqBO.getId(), reqBO.getArrayFieldName(), reqBO.getIdFieldName(), reqBO.getIdValue(), reqBOTemp.getMaps());
                        rsqBO.setRespDesc("ID=" + reqBO.getId() + "\u66f4\u65b0\u6210\u529f");
                    }
                    catch (Exception e) {
                        rsqBO.setRespCode("8888");
                        rsqBO.setRespDesc("\u66f4\u65b0\u6570\u7ec4\u5b57\u6bb5\uff08\u6307\u5b9a\u6570\u7ec4ID\uff09\u5931\u8d25\uff1a" + e.getMessage());
                        e.printStackTrace();
                    }
                    break block11;
                }
                Runnable run = () -> {
                    try {
                        if (StringUtils.isBlank((CharSequence)reqBO.getId())) {
                            String res = this.nosqlManager.updateByScript(reqBO.getIndex(), reqBO.getNosqlBuilder(), reqBO.getArrayFieldName(), reqBO.getIdFieldName(), reqBO.getIdValue(), reqBOTemp.getMaps());
                            rsqBO.setRespDesc(res);
                        } else {
                            this.nosqlManager.updateByScript(reqBO.getIndex(), reqBO.getId(), reqBO.getArrayFieldName(), reqBO.getIdFieldName(), reqBO.getIdValue(), reqBOTemp.getMaps());
                            rsqBO.setRespDesc("ID=" + reqBO.getId() + "\u66f4\u65b0\u6210\u529f");
                        }
                    }
                    catch (Exception e) {
                        rsqBO.setRespCode("8888");
                        rsqBO.setRespDesc("\u66f4\u65b0\u6570\u7ec4\u5b57\u6bb5\uff08\u6307\u5b9a\u6570\u7ec4ID\uff09\u5931\u8d25\uff1a" + e.getMessage());
                        e.printStackTrace();
                    }
                };
                ExecutorProcessPool.getInstance().executeByCustomThread(run);
            }
            catch (Exception e) {
                rsqBO.setRespCode("8888");
                rsqBO.setRespDesc("\u811a\u672c\u4fee\u6539\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return rsqBO;
    }

    @Override
    public NosqlUpdateBatchByBuilderRsqBO updateBatchByBuilder(NosqlUpdateBatchByBuilderReqBO reqBO) {
        NosqlUpdateBatchByBuilderRsqBO rsqBO = new NosqlUpdateBatchByBuilderRsqBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getIndex())) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u6279\u91cf\u66f4\u65b0\u6570\u636e\uff08\u53ea\u66f4\u65b0\u6709\u503c\u7684\u5b57\u6bb5\uff09\u5931\u8d25\uff1a\u7d22\u5f15\u540d\u79f0[index]\u4e0d\u80fd\u4e3a\u7a7a");
            return rsqBO;
        }
        Boolean result = false;
        try {
            result = this.nosqlManager.updateBatchData(reqBO.getIndex(), reqBO.getMaps(), reqBO.getNosqlBuilder());
            if (!result.booleanValue()) {
                rsqBO.setRespCode("8888");
                rsqBO.setRespDesc("\u6279\u91cf\u66f4\u65b0\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u6279\u91cf\u66f4\u65b0\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
            e.printStackTrace();
        }
        return rsqBO;
    }

    @Override
    public NosqlDeleteSingleRsqBO deleteSingle(NosqlDeleteSingleReqBO reqBO) {
        NosqlDeleteSingleRsqBO rsqBO = new NosqlDeleteSingleRsqBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getIndex())) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u5220\u9664\u6570\u636e\uff08\u5355\u6761\uff09\u5931\u8d25\uff1a\u7d22\u5f15\u540d\u79f0[index]\u4e0d\u80fd\u4e3a\u7a7a");
            return rsqBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getId())) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u5220\u9664\u6570\u636e\uff08\u5355\u6761\uff09\u5931\u8d25\uff1aID[id]\u4e0d\u80fd\u4e3a\u7a7a");
            return rsqBO;
        }
        try {
            boolean result = this.nosqlManager.deleteData(reqBO.getIndex(), reqBO.getId());
            if (result) {
                return rsqBO;
            }
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u6267\u884c\u5931\u8d25");
            return rsqBO;
        }
        catch (Exception e) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u5220\u9664\u5355\u4e2a\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
            return rsqBO;
        }
    }

    @Override
    public NosqlDeleteBatchRsqBO deleteBatch(NosqlDeleteBatchReqBO reqBO) {
        NosqlDeleteBatchRsqBO rsqBO = new NosqlDeleteBatchRsqBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getIndex())) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u5220\u9664\u6570\u636e\uff08\u5355\u6761\uff09\u5931\u8d25\uff1a\u7d22\u5f15\u540d\u79f0[index]\u4e0d\u80fd\u4e3a\u7a7a");
            return rsqBO;
        }
        if (reqBO.getIds() == null || reqBO.getIds().isEmpty()) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u5220\u9664\u6570\u636e\uff08\u5355\u6761\uff09\u5931\u8d25\uff1aID\u5217\u8868[ids]\u4e0d\u80fd\u4e3a\u7a7a");
            return rsqBO;
        }
        try {
            boolean result = this.nosqlManager.deleteBatchData(reqBO.getIndex(), reqBO.getIds());
            if (result) {
                return rsqBO;
            }
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u6267\u884c\u5931\u8d25");
            return rsqBO;
        }
        catch (Exception e) {
            rsqBO.setRespCode("8888");
            rsqBO.setRespDesc("\u6279\u91cf\u5220\u9664\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
            return rsqBO;
        }
    }

    @Override
    public NosqlDeleteByBuilderRsqBO deleteBatchByBuilder(NosqlDeleteByBuilderReqBO reqBO) {
        return null;
    }

    public String addData(String index, String id, JSONObject object) {
        return this.nosqlManager.addData(index, id, object);
    }

    public Boolean deleteSingle(String index, String id) {
        return null;
    }

    public void addBatch(String index, List<Map<String, JSONObject>> list) {
        this.nosqlManager.addBatch(index, list);
    }

    public Boolean deleteDataByCondition(String endPoint, JSONObject qryJson) {
        return this.nosqlManager.deleteDataByCondition(endPoint, qryJson);
    }

    public Boolean updateData(String index, String id, JSONObject qryJson) throws Exception {
        return this.nosqlManager.updateData(index, id, qryJson);
    }

    public Boolean updateBatchData(String index, Map<String, Map<String, Object>> maps) throws IOException {
        return this.nosqlManager.updateBatchData(index, maps);
    }

    public Boolean deleteData(String index, String id) {
        return this.nosqlManager.deleteData(index, id);
    }

    public Boolean deleteBatchData(String index, List<String> ids) {
        return this.nosqlManager.deleteBatchData(index, ids);
    }

    public String updateByQuery(String index, String qryJson) {
        return this.nosqlManager.updateByQuery(index, qryJson);
    }
}

